/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.common.v1;

import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.EnumValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import java.util.List;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;

public class BanyandbCommonValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbCommon.Metadata.class)) {
            return new MetadataValidator();
        }
        if (clazz.equals(BanyandbCommon.IntervalRule.class)) {
            return new IntervalRuleValidator();
        }
        if (clazz.equals(BanyandbCommon.LifecycleStage.class)) {
            return new LifecycleStageValidator();
        }
        if (clazz.equals(BanyandbCommon.ResourceOpts.class)) {
            return new ResourceOptsValidator();
        }
        if (clazz.equals(BanyandbCommon.Group.class)) {
            return new GroupValidator();
        }
        if (clazz.equals(BanyandbCommon.Trace.class)) {
            return new TraceValidator();
        }
        if (clazz.equals(BanyandbCommon.Span.class)) {
            return new SpanValidator();
        }
        if (clazz.equals(BanyandbCommon.Tag.class)) {
            return new TagValidator();
        }
        if (clazz.equals(BanyandbCommon.APIVersion.class)) {
            return new APIVersionValidator();
        }
        if (clazz.equals(BanyandbCommon.GetAPIVersionRequest.class)) {
            return new GetAPIVersionRequestValidator();
        }
        if (clazz.equals(BanyandbCommon.GetAPIVersionResponse.class)) {
            return new GetAPIVersionResponseValidator();
        }
        return null;
    }

    public static class MetadataValidator
    implements ValidatorImpl<BanyandbCommon.Metadata> {
        public void assertValid(BanyandbCommon.Metadata proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class IntervalRuleValidator
    implements ValidatorImpl<BanyandbCommon.IntervalRule> {
        private final Integer NUM__GT = 0;

        public void assertValid(BanyandbCommon.IntervalRule proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".banyandb.common.v1.IntervalRule.unit", (ProtocolMessageEnum)proto.getUnit());
            ComparativeValidation.greaterThan((String)".banyandb.common.v1.IntervalRule.num", (Object)proto.getNum(), (Object)this.NUM__GT, Comparator.naturalOrder());
        }
    }

    public static class LifecycleStageValidator
    implements ValidatorImpl<BanyandbCommon.LifecycleStage> {
        private final Integer SHARD_NUM__GT = 0;

        public void assertValid(BanyandbCommon.LifecycleStage proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".banyandb.common.v1.LifecycleStage.name", (String)proto.getName(), (int)1);
            ComparativeValidation.greaterThan((String)".banyandb.common.v1.LifecycleStage.shard_num", (Object)proto.getShardNum(), (Object)this.SHARD_NUM__GT, Comparator.naturalOrder());
            if (proto.hasSegmentInterval()) {
                RequiredValidation.required((String)".banyandb.common.v1.LifecycleStage.segment_interval", (Message)proto.getSegmentInterval());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.LifecycleStage.segment_interval", null);
            }
            if (proto.hasSegmentInterval()) {
                index.validatorFor((Object)proto.getSegmentInterval()).assertValid((Object)proto.getSegmentInterval());
            }
            if (proto.hasTtl()) {
                RequiredValidation.required((String)".banyandb.common.v1.LifecycleStage.ttl", (Message)proto.getTtl());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.LifecycleStage.ttl", null);
            }
            if (proto.hasTtl()) {
                index.validatorFor((Object)proto.getTtl()).assertValid((Object)proto.getTtl());
            }
            StringValidation.minLength((String)".banyandb.common.v1.LifecycleStage.node_selector", (String)proto.getNodeSelector(), (int)1);
        }
    }

    public static class ResourceOptsValidator
    implements ValidatorImpl<BanyandbCommon.ResourceOpts> {
        private final Integer SHARD_NUM__GT = 0;

        public void assertValid(BanyandbCommon.ResourceOpts proto, ValidatorIndex index) throws ValidationException {
            ComparativeValidation.greaterThan((String)".banyandb.common.v1.ResourceOpts.shard_num", (Object)proto.getShardNum(), (Object)this.SHARD_NUM__GT, Comparator.naturalOrder());
            if (proto.hasSegmentInterval()) {
                index.validatorFor((Object)proto.getSegmentInterval()).assertValid((Object)proto.getSegmentInterval());
            }
            if (proto.hasTtl()) {
                index.validatorFor((Object)proto.getTtl()).assertValid((Object)proto.getTtl());
            }
            RepeatedValidation.forEach(proto.getStagesList(), item -> index.validatorFor(item).assertValid(item));
            RepeatedValidation.forEach((List)proto.getDefaultStagesList(), item -> {});
        }
    }

    public static class GroupValidator
    implements ValidatorImpl<BanyandbCommon.Group> {
        public void assertValid(BanyandbCommon.Group proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.common.v1.Group.metadata", (Message)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.Group.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasResourceOpts()) {
                index.validatorFor((Object)proto.getResourceOpts()).assertValid((Object)proto.getResourceOpts());
            }
            if (proto.hasUpdatedAt()) {
                index.validatorFor((Object)proto.getUpdatedAt()).assertValid((Object)proto.getUpdatedAt());
            }
        }
    }

    public static class TraceValidator
    implements ValidatorImpl<BanyandbCommon.Trace> {
        public void assertValid(BanyandbCommon.Trace proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getSpansList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class SpanValidator
    implements ValidatorImpl<BanyandbCommon.Span> {
        public void assertValid(BanyandbCommon.Span proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasStartTime()) {
                index.validatorFor((Object)proto.getStartTime()).assertValid((Object)proto.getStartTime());
            }
            if (proto.hasEndTime()) {
                index.validatorFor((Object)proto.getEndTime()).assertValid((Object)proto.getEndTime());
            }
            RepeatedValidation.forEach(proto.getTagsList(), item -> index.validatorFor(item).assertValid(item));
            RepeatedValidation.forEach(proto.getChildrenList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TagValidator
    implements ValidatorImpl<BanyandbCommon.Tag> {
        public void assertValid(BanyandbCommon.Tag proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class APIVersionValidator
    implements ValidatorImpl<BanyandbCommon.APIVersion> {
        public void assertValid(BanyandbCommon.APIVersion proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class GetAPIVersionRequestValidator
    implements ValidatorImpl<BanyandbCommon.GetAPIVersionRequest> {
        public void assertValid(BanyandbCommon.GetAPIVersionRequest proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class GetAPIVersionResponseValidator
    implements ValidatorImpl<BanyandbCommon.GetAPIVersionResponse> {
        public void assertValid(BanyandbCommon.GetAPIVersionResponse proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVersion()) {
                index.validatorFor((Object)proto.getVersion()).assertValid((Object)proto.getVersion());
            }
        }
    }
}

