/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v6;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.factory.IndexFactory;
import org.apache.skywalking.library.elasticsearch.response.Mappings;

final class V6IndexFactory
implements IndexFactory {
    private final ElasticSearchVersion version;

    @Override
    public HttpRequest exists(String index) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        return HttpRequest.builder().head("/{index}").pathParam("index", (Object)index).build();
    }

    @Override
    public HttpRequest get(String index) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        return HttpRequest.builder().get("/{index}").pathParam("index", (Object)index).build();
    }

    @Override
    public HttpRequest create(String index, Mappings mappings, Map<String, ?> settings) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        ImmutableMap.Builder bodyBuilder = ImmutableMap.builder();
        if (mappings != null) {
            bodyBuilder.put((Object)"mappings", (Object)mappings);
        }
        if (settings != null) {
            bodyBuilder.put((Object)"settings", settings);
        }
        ImmutableMap body = bodyBuilder.build();
        byte[] content = this.version.codec().encode(body);
        return HttpRequest.builder().put("/{index}").pathParam("index", (Object)index).content(MediaType.JSON, content).build();
    }

    @Override
    public HttpRequest delete(String index) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        return HttpRequest.builder().delete("/{index}").pathParam("index", (Object)index).build();
    }

    @Override
    public HttpRequest putMapping(String index, String type, Mappings mapping) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        byte[] content = this.version.codec().encode(mapping);
        return HttpRequest.builder().put("/{index}/_mapping/{type}").pathParam("index", (Object)index).pathParam("type", (Object)type).content(MediaType.JSON, content).build();
    }

    @Generated
    public V6IndexFactory(ElasticSearchVersion version) {
        this.version = version;
    }
}

