/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.common;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestBuilder;
import com.linecorp.armeria.common.MediaType;
import java.util.HashMap;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.factory.SearchFactory;
import org.apache.skywalking.library.elasticsearch.requests.search.Scroll;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonSearchFactory
implements SearchFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonSearchFactory.class);
    private final ElasticSearchVersion version;

    @Override
    public HttpRequest search(Search search, SearchParams params, String ... indices) {
        HttpRequestBuilder builder = HttpRequest.builder();
        if (indices == null || indices.length == 0) {
            builder.get("/_search");
        } else {
            builder.get("/{indices}/_search").pathParam("indices", (Object)String.join((CharSequence)",", indices));
        }
        if (params != null) {
            params.forEach(e -> builder.queryParam((String)e.getKey(), e.getValue()));
        }
        byte[] content = this.version.codec().encode(search);
        if (log.isDebugEnabled()) {
            log.debug("Search request: {}", (Object)new String(content));
        }
        return builder.content(MediaType.JSON, content).build();
    }

    @Override
    public HttpRequest scroll(Scroll scroll) {
        HttpRequestBuilder builder = HttpRequest.builder().get("/_search/scroll");
        byte[] content = this.version.codec().encode(scroll);
        if (log.isDebugEnabled()) {
            log.debug("Scroll request: {}", (Object)new String(content));
        }
        return builder.content(MediaType.JSON, content).build();
    }

    @Override
    public HttpRequest deleteScrollContext(String scrollId) {
        HttpRequestBuilder builder = HttpRequest.builder().delete("/_search/scroll");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scroll_id", scrollId);
        byte[] content = this.version.codec().encode(params);
        if (log.isDebugEnabled()) {
            log.debug("Delete scroll context request: {}", (Object)new String(content));
        }
        return builder.content(MediaType.JSON, content).build();
    }

    @Generated
    public CommonSearchFactory(ElasticSearchVersion version) {
        this.version = version;
    }
}

