/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.client;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.search.Scroll;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchClient.class);
    private final CompletableFuture<ElasticSearchVersion> version;
    private final WebClient client;

    public SearchResponse search(Search criteria, SearchParams params, String ... index) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().search().search(criteria, params, index)).aggregate().thenApply(response -> {
            if (response.status() != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
            try (HttpData content = response.content();){
                SearchResponse searchResponse;
                block15: {
                    InputStream is = content.toInputStream();
                    try {
                        searchResponse = v.codec().decode(is, SearchResponse.class);
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return searchResponse;
            }
            catch (Exception e) {
                return (SearchResponse)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to search, request {}, params {}, index {}", new Object[]{criteria, params, index, exception});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to search index {}, {}", (Object)index, result);
            }
        });
        return (SearchResponse)((CompletableFuture)future).get();
    }

    public SearchResponse scroll(Scroll scroll) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().search().scroll(scroll)).aggregate().thenApply(response -> {
            if (response.status() != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
            try (HttpData content = response.content();){
                SearchResponse searchResponse;
                block15: {
                    InputStream is = content.toInputStream();
                    try {
                        searchResponse = v.codec().decode(is, SearchResponse.class);
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return searchResponse;
            }
            catch (Exception e) {
                return (SearchResponse)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to scroll, request {}, {}", (Object)scroll, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to scroll, {}", result);
            }
        });
        return (SearchResponse)((CompletableFuture)future).get();
    }

    public boolean deleteScrollContext(String scrollId) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().search().deleteScrollContext(scrollId)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to delete scroll context, request {}, {}", (Object)scrollId, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to delete scroll context, {}", result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    @Generated
    public SearchClient(CompletableFuture<ElasticSearchVersion> version, WebClient client) {
        this.version = version;
        this.client = client;
    }
}

