/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.ResponseCompleteException;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.ShuttingDownException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.metric.NoopMeterRegistry;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.client.ClosedStreamExceptionUtil;
import com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandler;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.RequestTargetCache;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.AccessLogWriterUtil;
import com.linecorp.armeria.server.AggregatedHttpResponseHandler;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http2ServerConnectionHandler;
import com.linecorp.armeria.server.HttpHeaderUtil;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpResponseSubscriber;
import com.linecorp.armeria.server.HttpServer;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServerPortMetric;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.TransientService;
import com.linecorp.armeria.server.WebSocketHttp1ResponseSubscriber;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpServerHandler
extends ChannelInboundHandlerAdapter
implements HttpServer {
    private static final Logger logger;
    private static final String ALLOWED_METHODS_STRING;
    private static final InetSocketAddress UNKNOWN_ADDR;
    private static final ChannelFutureListener CLOSE;
    static final ChannelFutureListener CLOSE_ON_FAILURE;
    private static boolean warnedRequestIdGenerateFailure;
    private static boolean warnedNullRequestId;
    private final ServerConfig config;
    private final ServerPortMetric serverPortMetric;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private SessionProtocol protocol;
    @Nullable
    private SSLSession sslSession;
    @Nullable
    private ServerHttpObjectEncoder responseEncoder;
    @Nullable
    private final ProxiedAddresses proxiedAddresses;
    private final InetSocketAddress remoteAddress;
    private final InetSocketAddress localAddress;
    private final IdentityHashMap<DecodedHttpRequest, HttpResponse> unfinishedRequests;
    private boolean isReading;
    private boolean isCleaning;
    private boolean isClosing;
    private boolean handledLastRequest;

    private static void logException(Channel ch, Throwable cause) {
        HttpServer server = HttpServer.get(ch);
        if (server != null) {
            Exceptions.logIfUnexpected(logger, ch, server.protocol(), cause);
        } else {
            Exceptions.logIfUnexpected(logger, ch, cause);
        }
    }

    static void safeClose(Channel ch) {
        if (!ch.isActive()) {
            return;
        }
        AbstractHttp2ConnectionHandler h2handler = (AbstractHttp2ConnectionHandler)ch.pipeline().get(AbstractHttp2ConnectionHandler.class);
        if (h2handler == null || !h2handler.isClosing()) {
            ch.close();
        }
    }

    HttpServerHandler(ServerConfig config, Channel channel, GracefulShutdownSupport gracefulShutdownSupport, @Nullable ServerHttpObjectEncoder responseEncoder, SessionProtocol protocol, @Nullable ProxiedAddresses proxiedAddresses) {
        assert (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C || protocol == SessionProtocol.H2);
        this.config = Objects.requireNonNull(config, "config");
        ServerPortMetric serverPortMetric = (ServerPortMetric)channel.attr(ServerPortMetric.SERVER_PORT_METRIC).get();
        assert (serverPortMetric != null);
        this.serverPortMetric = serverPortMetric;
        this.remoteAddress = MoreObjects.firstNonNull(ChannelUtil.remoteAddress(channel), UNKNOWN_ADDR);
        this.localAddress = MoreObjects.firstNonNull(ChannelUtil.localAddress(channel), UNKNOWN_ADDR);
        this.gracefulShutdownSupport = Objects.requireNonNull(gracefulShutdownSupport, "gracefulShutdownSupport");
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.responseEncoder = responseEncoder;
        this.proxiedAddresses = proxiedAddresses;
        this.unfinishedRequests = new IdentityHashMap();
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public int unfinishedRequests() {
        return this.unfinishedRequests.size();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup(ctx.channel(), false, null);
    }

    CompletableFuture<Void> shutdown(Channel channel) {
        CompletableFuture<Void> completionFuture = new CompletableFuture<Void>();
        channel.eventLoop().execute(() -> this.cleanup(channel, true, completionFuture));
        return completionFuture;
    }

    private void cleanup(Channel ch, boolean shutdown, @Nullable CompletableFuture<Void> completionFuture) {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        switch (this.protocol) {
            case H1C: 
            case H1: {
                ch.eventLoop().schedule(() -> this.cleanup0(ch, shutdown, completionFuture), 1L, TimeUnit.SECONDS);
                break;
            }
            default: {
                this.cleanup0(ch, shutdown, completionFuture);
            }
        }
    }

    private void cleanup0(Channel ch, boolean shutdown, @Nullable CompletableFuture<Void> completionFuture) {
        RuntimeException defaultCause;
        RuntimeException runtimeException = defaultCause = shutdown ? ShuttingDownException.get() : ClosedStreamExceptionUtil.newClosedSessionException(ch);
        if (!this.unfinishedRequests.isEmpty()) {
            this.isCleaning = true;
            this.unfinishedRequests.forEach((req, res) -> {
                boolean cancel = !this.protocol.isMultiplex();
                Throwable cause = null;
                if (shutdown) {
                    cause = this.shutdownError((DecodedHttpRequest)req);
                }
                if (cause == null) {
                    cause = defaultCause;
                }
                req.abortResponse(cause, cancel);
            });
            if (completionFuture != null) {
                CompletableFuture[] futures = (CompletableFuture[])this.unfinishedRequests.keySet().stream().map(DecodedHttpRequest::whenResponseSent).toArray(CompletableFuture[]::new);
                CompletableFuture.allOf(futures).handle((unused0, unused1) -> {
                    completionFuture.complete(null);
                    if (this.responseEncoder != null) {
                        this.responseEncoder.close(defaultCause);
                    }
                    return null;
                });
            } else if (this.responseEncoder != null) {
                this.responseEncoder.close(defaultCause);
            }
            this.unfinishedRequests.clear();
        }
    }

    @Nullable
    private Throwable shutdownError(DecodedHttpRequest req) {
        ServiceRequestContext ctx = req.requestContext();
        if (ctx == null) {
            return null;
        }
        try {
            return this.config.gracefulShutdown().toException(ctx, req);
        }
        catch (Exception e) {
            logger.warn("{} Unexpected exception from gracefulShutdown.toException(): {}", new Object[]{ctx, this.config.gracefulShutdown(), e});
            return null;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.isReading = true;
        if (msg instanceof Http2Settings) {
            this.handleHttp2Settings(ctx, (Http2Settings)msg);
        } else {
            this.handleRequest(ctx, (DecodedHttpRequest)msg);
        }
    }

    private void handleHttp2Settings(ChannelHandlerContext ctx, Http2Settings h2settings) {
        if (h2settings.isEmpty()) {
            logger.trace("{} HTTP/2 settings: <empty>", (Object)ctx.channel());
        } else {
            logger.debug("{} HTTP/2 settings: {}", (Object)ctx.channel(), (Object)h2settings);
        }
        if (this.protocol == SessionProtocol.H1) {
            this.protocol = SessionProtocol.H2;
        } else if (this.protocol == SessionProtocol.H1C) {
            this.protocol = SessionProtocol.H2C;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        ChannelHandlerContext connectionHandlerCtx = pipeline.context(Http2ServerConnectionHandler.class);
        Http2ServerConnectionHandler connectionHandler = (Http2ServerConnectionHandler)connectionHandlerCtx.handler();
        if (this.responseEncoder instanceof Http1ObjectEncoder) {
            this.responseEncoder.close(ClosedSessionException.get());
        }
        this.responseEncoder = connectionHandler.getOrCreateResponseEncoder(connectionHandlerCtx);
        int initialWindow = this.config.http2InitialConnectionWindowSize();
        if (initialWindow > 65535) {
            HttpServerHandler.incrementLocalWindowSize(pipeline, initialWindow - 65535);
        }
    }

    private static void incrementLocalWindowSize(ChannelPipeline pipeline, int delta) {
        try {
            Http2Connection connection = ((Http2ServerConnectionHandler)pipeline.get(Http2ServerConnectionHandler.class)).connection();
            ((Http2LocalFlowController)connection.local().flowController()).incrementWindowSize(connection.connectionStream(), delta);
        }
        catch (Http2Exception e) {
            logger.warn("Failed to increment local flowController window size: {}", (Object)delta, (Object)e);
        }
    }

    private void handleRequest(ChannelHandlerContext ctx, DecodedHttpRequest req) throws Exception {
        boolean isTransientService;
        ServerHttpObjectEncoder responseEncoder = this.responseEncoder;
        assert (responseEncoder != null);
        if (this.handledLastRequest) {
            req.abort();
            this.decreasePendingRequests();
            return;
        }
        if (!req.isKeepAlive()) {
            this.handledLastRequest = true;
            responseEncoder.keepAliveHandler().disconnectWhenFinished();
        }
        Channel channel = ctx.channel();
        RequestHeaders headers = req.headers();
        ProxiedAddresses proxiedAddresses = this.determineProxiedAddresses(headers);
        InetAddress clientAddress = this.config.clientAddressMapper().apply(proxiedAddresses).getAddress();
        EventLoop channelEventLoop = channel.eventLoop();
        RoutingContext routingCtx = req.routingContext();
        RoutingStatus routingStatus = routingCtx.status();
        if (!routingStatus.routeMustExist()) {
            ServiceRequestContext reqCtx = this.newEarlyRespondingRequestContext(channel, req, proxiedAddresses, clientAddress, routingCtx, channelEventLoop);
            if (routingStatus == RoutingStatus.OPTIONS) {
                this.handleOptions(ctx, reqCtx);
                this.decreasePendingRequests();
                return;
            }
            throw new Error();
        }
        Routed<ServiceConfig> routed = req.route();
        assert (routed != null);
        RoutingResult routingResult = routed.routingResult();
        ServiceConfig serviceCfg = routed.value();
        HttpService service = serviceCfg.service();
        EventLoopGroup serviceWorkerGroup = serviceCfg.serviceWorkerGroup();
        EventLoop serviceEventLoop = serviceWorkerGroup == this.config.workerGroup() ? channelEventLoop : serviceWorkerGroup.next();
        DefaultServiceRequestContext reqCtx = new DefaultServiceRequestContext(serviceCfg, channel, serviceEventLoop, this.config.meterRegistry(), this.protocol, HttpServerHandler.nextRequestId(routingCtx, serviceCfg), routingCtx, routingResult, req.exchangeType(), req, this.sslSession, proxiedAddresses, clientAddress, this.remoteAddress, this.localAddress, req.requestStartTimeNanos(), req.requestStartTimeMicros(), serviceCfg.contextHook());
        req.init(reqCtx);
        CompletableFuture<Void> whenAggregated = req.whenAggregated();
        HttpResponse res = whenAggregated != null ? HttpResponse.of((CompletableFuture<? extends HttpResponse>)whenAggregated.thenApply(ignored -> {
            if (serviceEventLoop.inEventLoop()) {
                return this.serve0(req, service, reqCtx, req.isHttp1WebSocket());
            }
            return this.serveInServiceEventLoop(req, service, reqCtx, serviceEventLoop, req.isHttp1WebSocket());
        })) : (serviceEventLoop.inEventLoop() ? this.serve0(req, service, reqCtx, req.isHttp1WebSocket()) : this.serveInServiceEventLoop(req, service, reqCtx, serviceEventLoop, req.isHttp1WebSocket()));
        res = res.recover(cause -> {
            reqCtx.logBuilder().responseCause((Throwable)cause);
            try (SafeCloseable ignored = reqCtx.push();){
                HttpResponse httpResponse = serviceCfg.errorHandler().onServiceException(reqCtx, (Throwable)cause);
                return httpResponse;
            }
        });
        boolean bl = isTransientService = serviceCfg.service().as(TransientService.class) != null;
        if (!isTransientService) {
            this.gracefulShutdownSupport.inc();
        }
        this.unfinishedRequests.put(req, res);
        if (service.shouldCachePath(routingCtx.path(), routingCtx.query(), routed.route())) {
            reqCtx.log().whenComplete().thenAccept(log -> {
                int statusCode = log.responseHeaders().status().code();
                if (statusCode >= 200 && statusCode < 400) {
                    RequestTargetCache.putForServer(req.path(), routingCtx.requestTarget());
                }
            });
        }
        RequestAndResponseCompleteHandler handler = new RequestAndResponseCompleteHandler(channelEventLoop, ctx, reqCtx, req, isTransientService);
        req.whenComplete().handle(handler.requestCompleteHandler);
        CompletableFuture<Void> resWriteFuture = req.whenResponseSent();
        resWriteFuture.handle(handler.responseCompleteHandler);
        req.setResponse(res);
        if (req.isHttp1WebSocket()) {
            assert (responseEncoder instanceof Http1ObjectEncoder);
            WebSocketHttp1ResponseSubscriber resSubscriber = new WebSocketHttp1ResponseSubscriber(ctx, responseEncoder, reqCtx, req, resWriteFuture);
            res.subscribe(resSubscriber, (EventExecutor)channelEventLoop, SubscriptionOption.WITH_POOLED_OBJECTS);
        } else if (reqCtx.exchangeType().isResponseStreaming()) {
            HttpResponseSubscriber resSubscriber = new HttpResponseSubscriber(ctx, responseEncoder, reqCtx, req, resWriteFuture);
            res.subscribe(resSubscriber, (EventExecutor)channelEventLoop, SubscriptionOption.WITH_POOLED_OBJECTS);
        } else {
            AggregatedHttpResponseHandler resHandler = new AggregatedHttpResponseHandler(ctx, responseEncoder, reqCtx, req, resWriteFuture);
            res.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), (EventExecutor)channelEventLoop)).handle((BiFunction)resHandler);
        }
    }

    private void decreasePendingRequests() {
        if (this.protocol.isExplicitHttp1()) {
            this.serverPortMetric.decreasePendingHttp1Requests();
        } else {
            assert (this.protocol.isExplicitHttp2());
            this.serverPortMetric.decreasePendingHttp2Requests();
        }
    }

    private void increaseActiveRequests(boolean isHttp1WebSocket) {
        if (isHttp1WebSocket) {
            this.serverPortMetric.increaseActiveHttp1WebSocketRequests();
        } else if (this.protocol.isExplicitHttp1()) {
            this.serverPortMetric.increaseActiveHttp1Requests();
        } else {
            assert (this.protocol.isExplicitHttp2());
            this.serverPortMetric.increaseActiveHttp2Requests();
        }
    }

    private HttpResponse serve0(HttpRequest req, HttpService service, DefaultServiceRequestContext reqCtx, boolean isHttp1WebSocket) {
        SafeCloseable ignored = reqCtx.push();
        try {
            this.decreasePendingRequests();
            this.increaseActiveRequests(isHttp1WebSocket);
            HttpResponse httpResponse = service.serve((ServiceRequestContext)reqCtx, req);
            if (ignored != null) {
                ignored.close();
            }
            return httpResponse;
        }
        catch (Throwable cause) {
            try {
                if (cause instanceof HttpResponseException || cause instanceof HttpStatusException) {
                    req.abort(ResponseCompleteException.get());
                } else {
                    req.abort(cause);
                }
                HttpResponse httpResponse = HttpResponse.ofFailure(cause);
                return httpResponse;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
    }

    private HttpResponse serveInServiceEventLoop(DecodedHttpRequest req, HttpService service, DefaultServiceRequestContext reqCtx, EventLoop serviceEventLoop, boolean isHttp1WebSocket) {
        return HttpResponse.of(() -> this.serve0(req.subscribeOn((EventExecutor)serviceEventLoop), service, reqCtx, isHttp1WebSocket), (Executor)serviceEventLoop).subscribeOn((EventExecutor)serviceEventLoop);
    }

    private ProxiedAddresses determineProxiedAddresses(RequestHeaders headers) {
        if (this.config.clientAddressTrustedProxyFilter().test(this.remoteAddress.getAddress())) {
            return HttpHeaderUtil.determineProxiedAddresses(headers, this.config.clientAddressSources(), this.proxiedAddresses, this.remoteAddress, this.config.clientAddressFilter());
        }
        return this.proxiedAddresses != null ? this.proxiedAddresses : ProxiedAddresses.of(this.remoteAddress);
    }

    private void handleOptions(ChannelHandlerContext ctx, ServiceRequestContext reqCtx) {
        this.respond(ctx, reqCtx, ResponseHeaders.builder(HttpStatus.OK).add((CharSequence)HttpHeaderNames.ALLOW, ALLOWED_METHODS_STRING), HttpData.empty(), null);
    }

    private void respond(ChannelHandlerContext ctx, ServiceRequestContext reqCtx, ResponseHeadersBuilder resHeaders, HttpData resContent, @Nullable Throwable cause) {
        if (!this.handledLastRequest) {
            this.respond(reqCtx, resHeaders, resContent, cause).addListener((GenericFutureListener)CLOSE_ON_FAILURE);
        } else {
            this.respond(reqCtx, resHeaders, resContent, cause).addListener((GenericFutureListener)CLOSE);
        }
        if (!this.isReading) {
            ctx.flush();
        }
    }

    private ChannelFuture respond(ServiceRequestContext reqCtx, ResponseHeadersBuilder resHeaders, HttpData resContent, @Nullable Throwable cause) {
        DecodedHttpRequest req = (DecodedHttpRequest)reqCtx.request();
        if (req instanceof HttpRequestWriter) {
            ((HttpRequestWriter)((Object)req)).close();
        }
        RequestLogBuilder logBuilder = reqCtx.logBuilder();
        if (cause == null) {
            logBuilder.endRequest();
        } else {
            logBuilder.endRequest(cause);
        }
        boolean hasContent = !resContent.isEmpty();
        logBuilder.startResponse();
        assert (this.responseEncoder != null);
        if (this.handledLastRequest) {
            this.addConnectionCloseHeaders(resHeaders);
        }
        HttpServerHandler.setContentLength(req, resHeaders, hasContent ? resContent.length() : 0);
        ResponseHeaders immutableResHeaders = resHeaders.build();
        ChannelFuture future = this.responseEncoder.writeHeaders(req.id(), req.streamId(), immutableResHeaders, !hasContent, reqCtx.method());
        logBuilder.responseHeaders(immutableResHeaders);
        if (hasContent) {
            logBuilder.increaseResponseLength(resContent);
            future = this.responseEncoder.writeData(req.id(), req.streamId(), resContent, true);
        }
        future.addListener(f -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                if (cause == null && f.isSuccess()) {
                    logBuilder.endResponse();
                } else {
                    logBuilder.endResponse(MoreObjects.firstNonNull(cause, f.cause()));
                }
            }
            AccessLogWriterUtil.maybeWriteAccessLog(reqCtx);
        });
        return future;
    }

    private void addConnectionCloseHeaders(ResponseHeadersBuilder headers) {
        if (this.protocol == SessionProtocol.H1 || this.protocol == SessionProtocol.H1C) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, HttpHeadersUtil.CLOSE_STRING);
        }
    }

    private static void setContentLength(HttpRequest req, ResponseHeadersBuilder headers, int contentLength) {
        if (req.method() == HttpMethod.HEAD || headers.status().isContentAlwaysEmpty()) {
            return;
        }
        headers.contentLength(contentLength);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.isReading = false;
        ctx.flush();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandler sslHandler = (SslHandler)ctx.channel().pipeline().get(SslHandler.class);
            this.sslSession = sslHandler != null ? sslHandler.engine().getSession() : null;
            return;
        }
        if (evt instanceof SslCloseCompletionEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)ctx.channel(), evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exceptions.logIfUnexpected(logger, ctx.channel(), this.protocol, cause);
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }

    private ServiceRequestContext newEarlyRespondingRequestContext(Channel channel, DecodedHttpRequest req, ProxiedAddresses proxiedAddresses, InetAddress clientAddress, RoutingContext routingCtx, EventLoop eventLoop) {
        ServiceConfig serviceConfig = routingCtx.virtualHost().fallbackServiceConfig();
        RoutingResult routingResult = RoutingResult.builder().path(routingCtx.path()).build();
        return new DefaultServiceRequestContext(serviceConfig, channel, eventLoop, NoopMeterRegistry.get(), this.protocol(), HttpServerHandler.nextRequestId(routingCtx, serviceConfig), routingCtx, routingResult, req.exchangeType(), req, this.sslSession, proxiedAddresses, clientAddress, this.remoteAddress, this.localAddress, System.nanoTime(), SystemInfo.currentTimeMicros(), RequestContextUtil.NOOP_CONTEXT_HOOK);
    }

    private static RequestId nextRequestId(RoutingContext routingCtx, ServiceConfig serviceConfig) {
        try {
            RequestId id = serviceConfig.requestIdGenerator().apply(routingCtx);
            if (id != null) {
                return id;
            }
            if (!warnedNullRequestId) {
                warnedNullRequestId = true;
                logger.warn("requestIdGenerator.apply(routingCtx) returned null; using RequestId.random()");
            }
            return RequestId.random();
        }
        catch (Exception e) {
            if (!warnedRequestIdGenerateFailure) {
                warnedRequestIdGenerateFailure = true;
                logger.warn("requestIdGenerator.apply(routingCtx) threw an exception; using RequestId.random()", (Throwable)e);
            }
            return RequestId.random();
        }
    }

    static {
        InetAddress unknownAddr;
        logger = LoggerFactory.getLogger(HttpServerHandler.class);
        ALLOWED_METHODS_STRING = HttpMethod.knownMethods().stream().map(Enum::name).collect(Collectors.joining(","));
        try {
            unknownAddr = InetAddress.getByAddress("<unknown>", new byte[]{0, 0, 0, 0});
        }
        catch (Exception e1) {
            try {
                unknownAddr = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            }
            catch (Exception e2) {
                Error err = new Error(e2);
                err.addSuppressed(e1);
                throw err;
            }
        }
        UNKNOWN_ADDR = new InetSocketAddress(unknownAddr, 1);
        CLOSE = future -> {
            Throwable cause = future.cause();
            Channel ch = future.channel();
            if (cause != null) {
                HttpServerHandler.logException(ch, cause);
            }
            HttpServerHandler.safeClose(ch);
        };
        CLOSE_ON_FAILURE = future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                return;
            }
            if (cause instanceof ClosedSessionException) {
                HttpServerHandler.safeClose(future.channel());
                return;
            }
            if (cause instanceof ClosedStreamException) {
                return;
            }
            Channel ch = future.channel();
            HttpServerHandler.logException(ch, cause);
            HttpServerHandler.safeClose(ch);
        };
    }

    private final class RequestAndResponseCompleteHandler {
        final BiFunction<Void, @Nullable Throwable, Void> requestCompleteHandler;
        final BiFunction<Void, @Nullable Throwable, Void> responseCompleteHandler;
        private boolean requestOrResponseComplete;
        private final ChannelHandlerContext ctx;
        private final DecodedHttpRequest req;
        private final boolean isTransientService;

        RequestAndResponseCompleteHandler(EventLoop eventLoop, ChannelHandlerContext ctx, ServiceRequestContext reqCtx, DecodedHttpRequest req, boolean isTransientService) {
            this.ctx = ctx;
            this.req = req;
            this.isTransientService = isTransientService;
            assert (HttpServerHandler.this.responseEncoder != null);
            this.requestCompleteHandler = (unused, cause) -> {
                if (eventLoop.inEventLoop()) {
                    this.handleRequestComplete(reqCtx.logBuilder(), (Throwable)cause);
                } else {
                    eventLoop.execute(() -> this.handleRequestComplete(reqCtx.logBuilder(), (Throwable)cause));
                }
                return null;
            };
            this.responseCompleteHandler = (unused, cause) -> {
                assert (eventLoop.inEventLoop());
                long requestAutoAbortDelayMillis = reqCtx.requestAutoAbortDelayMillis();
                if (cause != null || !req.isOpen() || requestAutoAbortDelayMillis == 0L) {
                    this.handleResponseComplete((Throwable)cause);
                    return null;
                }
                if (requestAutoAbortDelayMillis > 0L && requestAutoAbortDelayMillis < Long.MAX_VALUE) {
                    eventLoop.schedule(() -> this.handleResponseComplete(null), requestAutoAbortDelayMillis, TimeUnit.MILLISECONDS);
                    return null;
                }
                this.handleRequestOrResponseComplete();
                return null;
            };
        }

        private void handleRequestComplete(RequestLogBuilder logBuilder, @Nullable Throwable cause) {
            try {
                if (cause == null) {
                    logBuilder.endRequest();
                } else {
                    logBuilder.endRequest(cause);
                }
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception:", t);
            }
            this.handleRequestOrResponseComplete();
        }

        private void handleResponseComplete(@Nullable Throwable cause) {
            if (cause == null || !this.req.isOpen()) {
                this.req.abort(ResponseCompleteException.get());
            } else {
                this.req.abort(cause);
            }
            this.handleRequestOrResponseComplete();
        }

        private void handleRequestOrResponseComplete() {
            try {
                boolean needsDisconnection;
                if (!this.requestOrResponseComplete) {
                    this.requestOrResponseComplete = true;
                    return;
                }
                if (this.req.isHttp1WebSocket()) {
                    HttpServerHandler.this.serverPortMetric.decreaseActiveHttp1WebSocketRequests();
                } else if (HttpServerHandler.this.protocol.isExplicitHttp1()) {
                    HttpServerHandler.this.serverPortMetric.decreaseActiveHttp1Requests();
                } else if (HttpServerHandler.this.protocol.isExplicitHttp2()) {
                    HttpServerHandler.this.serverPortMetric.decreaseActiveHttp2Requests();
                }
                if (!this.isTransientService) {
                    HttpServerHandler.this.gracefulShutdownSupport.dec();
                }
                if (!HttpServerHandler.this.isCleaning) {
                    HttpServerHandler.this.unfinishedRequests.remove(this.req);
                }
                boolean bl = needsDisconnection = this.ctx.channel().isActive() && (HttpServerHandler.this.handledLastRequest || this.isNeedsDisconnection());
                if (needsDisconnection) {
                    if (HttpServerHandler.this.protocol.isMultiplex()) {
                        this.ctx.channel().close();
                    } else {
                        HttpServerHandler.this.handledLastRequest = true;
                        if (HttpServerHandler.this.unfinishedRequests.isEmpty()) {
                            long closeDelay = Flags.defaultHttp1ConnectionCloseDelayMillis();
                            if (closeDelay == 0L) {
                                this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)CLOSE);
                            } else {
                                this.ctx.channel().eventLoop().schedule(() -> {
                                    if (this.ctx.channel().isActive()) {
                                        this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)CLOSE);
                                    }
                                }, closeDelay, TimeUnit.MILLISECONDS);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception:", t);
            }
        }

        private boolean isNeedsDisconnection() {
            assert (HttpServerHandler.this.responseEncoder != null);
            return HttpServerHandler.this.responseEncoder.keepAliveHandler().needsDisconnection();
        }
    }
}

