/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.GraphqlTypeComparators;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLObjectType
implements GraphQLNamedOutputType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer,
GraphQLImplementingType {
    private final String name;
    private final String description;
    private final Comparator<? super GraphQLSchemaElement> interfaceComparator;
    private final ImmutableMap<String, GraphQLFieldDefinition> fieldDefinitionsByName;
    private final ImmutableList<GraphQLNamedOutputType> originalInterfaces;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    private final ObjectTypeDefinition definition;
    private final ImmutableList<ObjectTypeExtensionDefinition> extensionDefinitions;
    private ImmutableList<GraphQLNamedOutputType> replacedInterfaces;
    public static final String CHILD_INTERFACES = "interfaces";
    public static final String CHILD_FIELD_DEFINITIONS = "fieldDefinitions";

    @Internal
    private GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLNamedOutputType> interfaces, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, ObjectTypeDefinition definition, List<ObjectTypeExtensionDefinition> extensionDefinitions, Comparator<? super GraphQLSchemaElement> interfaceComparator) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
        Assert.assertNotNull(interfaces, () -> "interfaces can't be null");
        this.name = name;
        this.description = description;
        this.interfaceComparator = interfaceComparator;
        this.originalInterfaces = ImmutableList.copyOf(GraphqlTypeComparators.sortTypes(interfaceComparator, interfaces));
        this.definition = definition;
        this.extensionDefinitions = ImmutableList.copyOf(extensionDefinitions);
        this.directivesHolder = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
        this.fieldDefinitionsByName = this.buildDefinitionMap(fieldDefinitions);
    }

    void replaceInterfaces(List<GraphQLNamedOutputType> interfaces) {
        this.replacedInterfaces = ImmutableList.copyOf(GraphqlTypeComparators.sortTypes(this.interfaceComparator, interfaces));
    }

    private ImmutableMap<String, GraphQLFieldDefinition> buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        return ImmutableMap.copyOf(FpKit.getByName(fieldDefinitions, GraphQLFieldDefinition::getName, (fld1, fld2) -> (GraphQLFieldDefinition)Assert.assertShouldNeverHappen("Duplicated definition for field '%s' in type '%s'", fld1.getName(), this.name)));
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return ImmutableList.copyOf(this.fieldDefinitionsByName.values());
    }

    @Override
    public List<GraphQLNamedOutputType> getInterfaces() {
        if (this.replacedInterfaces != null) {
            return this.replacedInterfaces;
        }
        return this.originalInterfaces;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<ObjectTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    public String toString() {
        return "GraphQLObjectType{name='" + this.name + "', description='" + this.description + "', fieldDefinitionsByName=" + (ImmutableSet)this.fieldDefinitionsByName.keySet() + ", interfaces=" + this.getInterfaces() + "}";
    }

    public GraphQLObjectType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLObjectType.newObject(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLObjectType.newObject(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLObjectType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.fieldDefinitionsByName.values());
        children.addAll(this.getInterfaces());
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_FIELD_DEFINITIONS, this.fieldDefinitionsByName.values()).children(CHILD_INTERFACES, this.originalInterfaces).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).children("directives", this.directivesHolder.getDirectives()).build();
    }

    @Override
    public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceFields(newChildren.getChildren(CHILD_FIELD_DEFINITIONS)).replaceInterfaces(newChildren.getChildren(CHILD_INTERFACES)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public static Builder newObject() {
        return new Builder();
    }

    public static Builder newObject(GraphQLObjectType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private ObjectTypeDefinition definition;
        private List<ObjectTypeExtensionDefinition> extensionDefinitions = ImmutableKit.emptyList();
        private final Map<String, GraphQLFieldDefinition> fields = new LinkedHashMap<String, GraphQLFieldDefinition>();
        private final Map<String, GraphQLNamedOutputType> interfaces = new LinkedHashMap<String, GraphQLNamedOutputType>();

        public Builder() {
        }

        public Builder(GraphQLObjectType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.fields.putAll(FpKit.getByName(existing.getFieldDefinitions(), GraphQLFieldDefinition::getName));
            this.interfaces.putAll(FpKit.getByName(existing.originalInterfaces, GraphQLNamedSchemaElement::getName));
            this.copyExistingDirectives(existing);
        }

        public Builder definition(ObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<ObjectTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, () -> "fieldDefinition can't be null");
            this.fields.put(fieldDefinition.getName(), fieldDefinition);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction can't be null");
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = (GraphQLFieldDefinition.Builder)builderFunction.apply(builder);
            return this.field(builder.build());
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public Builder replaceFields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
            this.fields.clear();
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder withInterface(GraphQLInterfaceType interfaceType) {
            Assert.assertNotNull(interfaceType, () -> "interfaceType can't be null");
            this.interfaces.put(interfaceType.getName(), interfaceType);
            return this;
        }

        public Builder replaceInterfaces(List<? extends GraphQLNamedOutputType> interfaces) {
            Assert.assertNotNull(interfaces, () -> "interfaces can't be null");
            this.interfaces.clear();
            for (GraphQLNamedOutputType graphQLNamedOutputType : interfaces) {
                if (graphQLNamedOutputType instanceof GraphQLInterfaceType || graphQLNamedOutputType instanceof GraphQLTypeReference) {
                    this.interfaces.put(graphQLNamedOutputType.getName(), graphQLNamedOutputType);
                    continue;
                }
                Assert.assertShouldNeverHappen("Unexpected type " + (Serializable)(graphQLNamedOutputType != null ? graphQLNamedOutputType.getClass() : "null"), new Object[0]);
            }
            return this;
        }

        public Builder withInterface(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, () -> "reference can't be null");
            this.interfaces.put(reference.getName(), reference);
            return this;
        }

        public Builder withInterfaces(GraphQLInterfaceType ... interfaceType) {
            for (GraphQLInterfaceType type : interfaceType) {
                this.withInterface(type);
            }
            return this;
        }

        public Builder withInterfaces(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.withInterface(reference);
            }
            return this;
        }

        public Builder clearInterfaces() {
            this.interfaces.clear();
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLObjectType build() {
            return new GraphQLObjectType(this.name, this.description, this.sort(this.fields, GraphQLObjectType.class, GraphQLFieldDefinition.class), FpKit.valuesToList(this.interfaces), this.sort(this.directives, GraphQLObjectType.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLObjectType.class, GraphQLAppliedDirective.class), this.definition, this.extensionDefinitions, this.getComparator(GraphQLObjectType.class, GraphQLInterfaceType.class));
        }
    }
}

