/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Internal;
import graphql.execution.reactive.DelegatingSubscription;
import graphql.util.LockKit;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class CompletionStageMappingPublisher<D, U>
implements Publisher<D> {
    private final Publisher<U> upstreamPublisher;
    private final Function<U, CompletionStage<D>> mapper;

    public CompletionStageMappingPublisher(Publisher<U> upstreamPublisher, Function<U, CompletionStage<D>> mapper) {
        this.upstreamPublisher = upstreamPublisher;
        this.mapper = mapper;
    }

    public void subscribe(Subscriber<? super D> downstreamSubscriber) {
        this.upstreamPublisher.subscribe((Subscriber)new CompletionStageSubscriber(downstreamSubscriber));
    }

    public Publisher<U> getUpstreamPublisher() {
        return this.upstreamPublisher;
    }

    @Internal
    public class CompletionStageSubscriber
    implements Subscriber<U> {
        private final Subscriber<? super D> downstreamSubscriber;
        Subscription delegatingSubscription;
        final Queue<CompletionStage<?>> inFlightDataQ;
        final LockKit.ReentrantLock lock = new LockKit.ReentrantLock();
        final AtomicReference<Runnable> onCompleteOrErrorRun;
        final AtomicBoolean onCompleteOrErrorRunCalled;

        public CompletionStageSubscriber(Subscriber<? super D> downstreamSubscriber) {
            this.downstreamSubscriber = downstreamSubscriber;
            this.inFlightDataQ = new ArrayDeque();
            this.onCompleteOrErrorRun = new AtomicReference();
            this.onCompleteOrErrorRunCalled = new AtomicBoolean(false);
        }

        public void onSubscribe(Subscription subscription) {
            this.delegatingSubscription = new DelegatingSubscription(subscription);
            this.downstreamSubscriber.onSubscribe(this.delegatingSubscription);
        }

        public void onNext(U u) {
            if (this.onCompleteOrErrorRunCalled.get()) {
                return;
            }
            try {
                CompletionStage completionStage = CompletionStageMappingPublisher.this.mapper.apply(u);
                this.offerToInFlightQ(completionStage);
                completionStage.whenComplete(this.whenNextFinished(completionStage));
            }
            catch (RuntimeException throwable) {
                this.handleThrowable(throwable);
            }
        }

        private BiConsumer<D, Throwable> whenNextFinished(CompletionStage<D> completionStage) {
            return (d, throwable) -> {
                try {
                    if (throwable != null) {
                        this.handleThrowable((Throwable)throwable);
                    } else {
                        this.downstreamSubscriber.onNext(d);
                    }
                }
                finally {
                    Runnable runOnCompleteOrErrorRun = this.onCompleteOrErrorRun.get();
                    boolean empty = this.removeFromInFlightQAndCheckIfEmpty(completionStage);
                    if (empty && runOnCompleteOrErrorRun != null) {
                        this.onCompleteOrErrorRun.set(null);
                        runOnCompleteOrErrorRun.run();
                    }
                }
            };
        }

        private void handleThrowable(Throwable throwable) {
            this.downstreamSubscriber.onError(throwable);
            this.delegatingSubscription.cancel();
        }

        public void onError(Throwable t) {
            this.onCompleteOrError(() -> {
                this.onCompleteOrErrorRunCalled.set(true);
                this.downstreamSubscriber.onError(t);
            });
        }

        public void onComplete() {
            this.onCompleteOrError(() -> {
                this.onCompleteOrErrorRunCalled.set(true);
                this.downstreamSubscriber.onComplete();
            });
        }

        public Subscriber<? super D> getDownstreamSubscriber() {
            return this.downstreamSubscriber;
        }

        private void onCompleteOrError(Runnable doneCodeToRun) {
            if (this.inFlightQIsEmpty()) {
                doneCodeToRun.run();
            } else {
                this.onCompleteOrErrorRun.set(doneCodeToRun);
            }
        }

        private void offerToInFlightQ(CompletionStage<?> completionStage) {
            this.lock.runLocked(() -> this.inFlightDataQ.offer(completionStage));
        }

        private boolean removeFromInFlightQAndCheckIfEmpty(CompletionStage<?> completionStage) {
            return this.lock.callLocked(() -> {
                this.inFlightDataQ.remove(completionStage);
                return this.inFlightDataQ.isEmpty();
            });
        }

        private boolean inFlightQIsEmpty() {
            return this.lock.callLocked(this.inFlightDataQ::isEmpty);
        }
    }
}

