/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.PublicApi;
import graphql.ThreadSafe;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

@PublicApi
@ThreadSafe
public class GraphQLContext {
    private final ConcurrentMap<Object, Object> map;

    private GraphQLContext(ConcurrentMap<Object, Object> map) {
        this.map = map;
    }

    public GraphQLContext delete(Object key) {
        this.map.remove(Assert.assertNotNull(key));
        return this;
    }

    public <T> T get(Object key) {
        return (T)this.map.get(Assert.assertNotNull(key));
    }

    public <T> T getOrDefault(Object key, T defaultValue) {
        return (T)this.map.getOrDefault(Assert.assertNotNull(key), defaultValue);
    }

    public <T> Optional<T> getOrEmpty(Object key) {
        Object t = this.map.get(Assert.assertNotNull(key));
        return Optional.ofNullable(t);
    }

    public boolean hasKey(Object key) {
        return this.map.containsKey(Assert.assertNotNull(key));
    }

    public GraphQLContext put(Object key, Object value) {
        this.map.put(Assert.assertNotNull(key), Assert.assertNotNull(value));
        return this;
    }

    public GraphQLContext putAll(Map<?, Object> map) {
        Assert.assertNotNull(map);
        for (Map.Entry<?, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public GraphQLContext putAll(GraphQLContext context) {
        Assert.assertNotNull(context);
        return this.putAll(context.map);
    }

    public GraphQLContext putAll(Builder contextBuilder) {
        Assert.assertNotNull(contextBuilder);
        return this.putAll(contextBuilder.build());
    }

    public GraphQLContext putAll(Consumer<Builder> contextBuilderConsumer) {
        Assert.assertNotNull(contextBuilderConsumer);
        Builder builder = GraphQLContext.newContext();
        contextBuilderConsumer.accept(builder);
        return this.putAll(builder);
    }

    public Stream<Map.Entry<Object, Object>> stream() {
        return this.map.entrySet().stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphQLContext that = (GraphQLContext)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        return this.map.toString();
    }

    public static GraphQLContext of(Map<?, Object> mapOfContext) {
        return new Builder().of(mapOfContext).build();
    }

    public static GraphQLContext of(Consumer<Builder> contextBuilderConsumer) {
        Builder builder = GraphQLContext.newContext();
        contextBuilderConsumer.accept(builder);
        return GraphQLContext.of(builder.map);
    }

    public static GraphQLContext getDefault() {
        return GraphQLContext.newContext().build();
    }

    public static Builder newContext() {
        return new Builder();
    }

    public static class Builder {
        private final ConcurrentMap<Object, Object> map = new ConcurrentHashMap<Object, Object>();

        public Builder put(Object key1, Object value1) {
            return this.putImpl(key1, value1);
        }

        public Builder of(Object key1, Object value1) {
            return this.putImpl(key1, value1);
        }

        public Builder of(Object key1, Object value1, Object key2, Object value2) {
            return this.putImpl(key1, value1, key2, value2);
        }

        public Builder of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
            return this.putImpl(key1, value1, key2, value2, key3, value3);
        }

        public Builder of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4) {
            return this.putImpl(key1, value1, key2, value2, key3, value3, key4, value4);
        }

        public Builder of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4, Object key5, Object value5) {
            return this.putImpl(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
        }

        public Builder of(Map<?, Object> mapOfContext) {
            Assert.assertNotNull(mapOfContext);
            for (Map.Entry<?, Object> entry : mapOfContext.entrySet()) {
                this.map.put(Assert.assertNotNull(entry.getKey()), Assert.assertNotNull(entry.getValue()));
            }
            return this;
        }

        public Builder putAll(Map<?, Object> mapOfContext) {
            return this.of(mapOfContext);
        }

        public Builder of(GraphQLContext graphQLContext) {
            Assert.assertNotNull(graphQLContext);
            return this.of(graphQLContext.map);
        }

        public Builder of(Builder graphQLContextBuilder) {
            Assert.assertNotNull(graphQLContextBuilder);
            return this.of(graphQLContextBuilder.build());
        }

        private Builder putImpl(Object ... kvs) {
            for (int i = 0; i < kvs.length; i += 2) {
                Object k = kvs[i];
                Object v = kvs[i + 1];
                this.map.put(Assert.assertNotNull(k), Assert.assertNotNull(v));
            }
            return this;
        }

        public GraphQLContext build() {
            return new GraphQLContext(this.map);
        }
    }
}

