/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.provider.Spherical2Dto3D;
import org.apache.sis.referencing.operation.transform.EllipsoidToRadiusTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Spherical3Dto2D
extends AbstractProvider {
    private static final long serialVersionUID = -6165087357029633662L;
    public static final String NAME = "Spherical3D to 2D conversion";
    public static final ParameterDescriptorGroup PARAMETERS;
    private static final Spherical3Dto2D INSTANCE;

    public static Spherical3Dto2D provider() {
        return INSTANCE;
    }

    public Spherical3Dto2D() {
        super(Conversion.class, PARAMETERS, SphericalCS.class, false, SphericalCS.class, true, (byte)3);
    }

    @Override
    public AbstractProvider inverse() {
        return Spherical2Dto3D.provider();
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        return transform.getSourceDimensions() < transform.getTargetDimensions() ? Spherical2Dto3D.provider() : this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        Parameters values = Parameters.castOrWrap(context.getCompletedParameters());
        return EllipsoidToRadiusTransform.createGeodeticConversion(context.getFactory(), MapProjection.getEllipsoid(values, context));
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)Spherical3Dto2D.builder().setCodeSpace(Citations.SIS, "SIS");
        PARAMETERS = ((ParameterBuilder)builder.addName(NAME)).createGroupForMapProjection(new ParameterDescriptor[0]);
        INSTANCE = new Spherical3Dto2D();
    }
}

