/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.Set;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gts.TM_Duration;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DigitalTransferOptions_Type", propOrder={"unitsOfDistribution", "distributionFormat", "transferSize", "transferFrequency", "onLines", "offLines"})
@XmlRootElement(name="MD_DigitalTransferOptions")
public class DefaultDigitalTransferOptions
extends ISOMetadata
implements DigitalTransferOptions {
    private static final long serialVersionUID = -7094568309031595844L;
    private InternationalString unitsOfDistribution;
    private Double transferSize;
    private Collection<OnlineResource> onLines;
    private Collection<Medium> offLines;
    private TemporalAmount transferFrequency;
    private Collection<Format> distributionFormats;

    public DefaultDigitalTransferOptions() {
    }

    public DefaultDigitalTransferOptions(DigitalTransferOptions object) {
        super(object);
        if (object != null) {
            this.unitsOfDistribution = object.getUnitsOfDistribution();
            this.transferSize = object.getTransferSize();
            this.onLines = DefaultDigitalTransferOptions.copyCollection(object.getOnLines(), OnlineResource.class);
            if (object instanceof DefaultDigitalTransferOptions) {
                DefaultDigitalTransferOptions c = (DefaultDigitalTransferOptions)object;
                this.offLines = DefaultDigitalTransferOptions.copyCollection(c.getOffLines(), Medium.class);
                this.transferFrequency = c.getTransferFrequency();
                this.distributionFormats = DefaultDigitalTransferOptions.copyCollection(c.getDistributionFormats(), Format.class);
            } else {
                this.offLines = DefaultDigitalTransferOptions.singleton(object.getOffLine(), Medium.class);
            }
        }
    }

    public static DefaultDigitalTransferOptions castOrCopy(DigitalTransferOptions object) {
        if (object == null || object instanceof DefaultDigitalTransferOptions) {
            return (DefaultDigitalTransferOptions)object;
        }
        return new DefaultDigitalTransferOptions(object);
    }

    @XmlElement(name="unitsOfDistribution")
    public InternationalString getUnitsOfDistribution() {
        return this.unitsOfDistribution;
    }

    public void setUnitsOfDistribution(InternationalString newValue) {
        this.checkWritePermission(this.unitsOfDistribution);
        this.unitsOfDistribution = newValue;
    }

    @XmlElement(name="transferSize")
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getTransferSize() {
        return this.transferSize;
    }

    public void setTransferSize(Double newValue) {
        this.checkWritePermission(this.transferSize);
        if (ImplementationHelper.ensurePositive(DefaultDigitalTransferOptions.class, "transferSize", true, newValue)) {
            this.transferSize = newValue;
        }
    }

    @XmlElement(name="onLine")
    public Collection<OnlineResource> getOnLines() {
        this.onLines = this.nonNullCollection(this.onLines, OnlineResource.class);
        return this.onLines;
    }

    public void setOnLines(Collection<? extends OnlineResource> newValues) {
        this.onLines = this.writeCollection(newValues, this.onLines, OnlineResource.class);
    }

    @XmlElement(name="offLine")
    @UML(identifier="offLine", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Medium> getOffLines() {
        this.offLines = this.nonNullCollection(this.offLines, Medium.class);
        Set c = this.offLines;
        if (c != null && c.size() > 1 && FilterByVersion.LEGACY_METADATA.accept()) {
            c = CollectionsExt.singletonOrEmpty((Object)LegacyPropertyAdapter.getSingleton(c, Medium.class, null, DefaultDigitalTransferOptions.class, "getOffLines"));
        }
        return c;
    }

    public void setOffLines(Collection<? extends Medium> newValues) {
        this.offLines = this.writeCollection(newValues, this.offLines, Medium.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getOffLines"})
    public Medium getOffLine() {
        return LegacyPropertyAdapter.getSingleton(this.getOffLines(), Medium.class, null, DefaultDigitalTransferOptions.class, "getOffLine");
    }

    @Deprecated(since="1.0")
    public void setOffLine(Medium newValue) {
        this.setOffLines(CollectionsExt.singletonOrEmpty((Object)newValue));
    }

    @XmlElement(name="transferFrequency")
    @XmlJavaTypeAdapter(value=TM_Duration.Since2014.class)
    public TemporalAmount getTransferFrequency() {
        return this.transferFrequency;
    }

    public void setTransferFrequency(TemporalAmount newValue) {
        this.checkWritePermission(this.transferFrequency);
        this.transferFrequency = newValue;
    }

    @UML(identifier="distributionFormat", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Format> getDistributionFormats() {
        this.distributionFormats = this.nonNullCollection(this.distributionFormats, Format.class);
        return this.distributionFormats;
    }

    public void setDistributionFormats(Collection<? extends Format> newValues) {
        this.distributionFormats = this.writeCollection(newValues, this.distributionFormats, Format.class);
    }

    @XmlElement(name="distributionFormat")
    private Collection<Format> getDistributionFormat() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDistributionFormats() : null;
    }
}

