/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Map;
import java.util.function.Function;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.EnvelopeOperation;
import org.apache.sis.feature.ExpressionOperation;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.GroupAsPolylineOperation;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.StringJoinOperation;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.internal.shared.XPath;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class FeatureOperations
extends Static {
    static final WeakHashSet<AbstractIdentifiedType> POOL = new WeakHashSet(AbstractIdentifiedType.class);

    private FeatureOperations() {
    }

    public static AbstractOperation link(Map<String, ?> identification, AbstractIdentifiedType referent) {
        ArgumentChecks.ensureNonNull((String)"referent", (Object)referent);
        return (AbstractOperation)POOL.unique((Object)new LinkOperation(identification, referent));
    }

    public static AbstractOperation compound(Map<String, ?> identification, String delimiter, String prefix, String suffix, AbstractIdentifiedType ... singleAttributes) {
        AbstractIdentifiedType at;
        ArgumentChecks.ensureNonEmpty((String)"delimiter", (CharSequence)delimiter);
        if (delimiter.indexOf(92) >= 0) {
            throw new IllegalArgumentException(Errors.forProperties(identification).getString((short)63, (Object)"delimiter", (Object)Character.valueOf('\\')));
        }
        ArgumentChecks.ensureNonEmpty((String)"singleAttributes", (Object[])singleAttributes);
        if (singleAttributes.length == 1 && Strings.isNullOrEmpty((String)prefix) && Strings.isNullOrEmpty((String)suffix) && !((at = singleAttributes[0]) instanceof DefaultAssociationRole)) {
            return FeatureOperations.link(identification, at);
        }
        return (AbstractOperation)POOL.unique((Object)new StringJoinOperation(identification, delimiter, prefix, suffix, singleAttributes, null));
    }

    public static AbstractOperation envelope(Map<String, ?> identification, CoordinateReferenceSystem crs, AbstractIdentifiedType ... geometryAttributes) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"geometryAttributes", (Object)geometryAttributes);
        return (AbstractOperation)POOL.unique((Object)new EnvelopeOperation(identification, crs, geometryAttributes, null));
    }

    public static AbstractOperation groupAsPolyline(Map<String, ?> identification, GeometryLibrary library, AbstractIdentifiedType components) {
        ArgumentChecks.ensureNonNull((String)"library", (Object)library);
        ArgumentChecks.ensureNonNull((String)"components", (Object)components);
        return (AbstractOperation)POOL.unique((Object)GroupAsPolylineOperation.create(identification, library, components));
    }

    public static <V> AbstractOperation function(Map<String, ?> identification, Function<? super AbstractFeature, ? extends V> expression, DefaultAttributeType<? super V> resultType) {
        ArgumentChecks.ensureNonNull((String)"expression", expression);
        ArgumentChecks.ensureNonNull((String)"resultType", resultType);
        return (AbstractOperation)POOL.unique((Object)ExpressionOperation.create(identification, expression, resultType));
    }

    public static <V> AbstractOperation expression(Map<String, ?> identification, Expression<? super AbstractFeature, ?> expression, DefaultAttributeType<V> resultType) {
        return FeatureOperations.function(identification, expression.toValueType(resultType.getValueClass()), resultType);
    }

    public static Expression<? super AbstractFeature, ?> expressionOf(AbstractIdentifiedType property) {
        String name;
        Class type;
        Function expression;
        if (property instanceof ExpressionOperation && (expression = ((ExpressionOperation)property).expression) instanceof Expression) {
            return (Expression)expression;
        }
        if (property instanceof DefaultAttributeType) {
            type = ((DefaultAttributeType)property).getValueClass();
            name = null;
        } else {
            type = Object.class;
            name = Features.getLinkTarget(property).orElse(null);
        }
        if (name == null) {
            name = property.getName().toString();
        }
        return DefaultFilterFactory.forFeatures().property(XPath.fromPropertyName(name), type);
    }
}

