/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.internal.shared;

import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import javax.measure.Unit;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.measure.NumberRange;

public final class SampleDimensions {
    public static final ThreadLocal<List<SampleDimension>> IMAGE_PROCESSOR_ARGUMENT = new ThreadLocal();

    private SampleDimensions() {
    }

    public static Unit<?>[] units(BandedCoverage source) {
        List<SampleDimension> bands = source.getSampleDimensions();
        Unit[] units = new Unit[bands.size()];
        for (int i = 0; i < units.length; ++i) {
            units[i] = bands.get(i).getUnits().orElse(null);
        }
        return units;
    }

    public static NumberRange<?>[] ranges(BandedCoverage source) {
        List<SampleDimension> bands = source.getSampleDimensions();
        NumberRange[] ranges = new NumberRange[bands.size()];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = bands.get(i).getSampleRange().orElse(null);
        }
        return ranges;
    }

    public static Number[] backgrounds(List<SampleDimension> bands) {
        if (bands == null) {
            return null;
        }
        Number[] fillValues = new Number[bands.size()];
        int i = fillValues.length;
        while (--i >= 0) {
            Optional<Number> bg;
            SampleDimension band = bands.get(i);
            if (band == null || !(bg = band.getBackground()).isPresent()) continue;
            fillValues[i] = bg.get();
        }
        return fillValues;
    }

    public static DoubleUnaryOperator[] toSampleFilters(List<SampleDimension> bands) {
        if (bands == null) {
            return null;
        }
        DoubleUnaryOperator[] sampleFilters = new DoubleUnaryOperator[bands.size()];
        for (int i = 0; i < sampleFilters.length; ++i) {
            SampleDimension band = bands.get(i);
            if (band == null) continue;
            List<Category> categories = band.getCategories();
            int count = categories.size();
            Number[] nodataValues = new Number[count + 1];
            for (int j = 0; j < count; ++j) {
                Number value;
                Category category = categories.get(j);
                if (category.isQuantitative()) continue;
                NumberRange<?> range = category.getSampleRange();
                if (range.isMinIncluded()) {
                    value = (Number)((Object)range.getMinValue());
                } else {
                    if (!range.isMaxIncluded()) continue;
                    value = (Number)((Object)range.getMaxValue());
                }
                nodataValues[j] = value;
            }
            nodataValues[count] = band.getBackground().orElse(null);
            sampleFilters[i] = ImageProcessor.filterNodataValues(nodataValues);
        }
        return sampleFilters;
    }
}

