/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Duration;
import java.util.Locale;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public class GridSliceSelector
extends Widget {
    private static final int BIDIMENSIONAL = 2;
    private static final Insets PADDING = new Insets(3.0, 9.0, 3.0, 9.0);
    private static final int PIXELS_PER_CHAR = 10;
    private static final int MAX_MINOR_TICK_COUNT = 10;
    public final ObjectProperty<GridGeometry> gridGeometry;
    private final ReadOnlyObjectWrapper<GridExtent> selectedExtent;
    private int xDimension;
    private int yDimension;
    private final Locale locale;
    private final GridPane view;
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private DateFormat dateAndTimeFormat;
    private DateFormat longDateFormat;
    StatusBar status;

    public GridSliceSelector(Locale locale) {
        this.locale = locale;
        this.view = new GridPane();
        this.view.setVgap(9.0);
        this.view.setHgap(12.0);
        this.view.setPadding(PADDING);
        this.selectedExtent = new ReadOnlyObjectWrapper((Object)this, "selectedExtent");
        this.gridGeometry = new SimpleObjectProperty((Object)this, "gridGeometry");
        this.gridGeometry.addListener((p, o, n) -> this.setGridGeometry((GridGeometry)n));
        this.yDimension = 1;
    }

    private void setGridGeometry(GridGeometry gg) {
        GridExtent extent;
        ObservableList children = this.view.getChildren();
        if (gg == null || gg.getDimension() <= 2 || !gg.isDefined(4)) {
            this.selectedExtent.set(null);
            children.clear();
            return;
        }
        TransformSeparator gridToCRS = null;
        Envelope envelope = null;
        double[] resolution = null;
        Vocabulary vocabulary = null;
        int childrenCount = 0;
        int row = -3;
        GridExtent selected = extent = gg.getExtent();
        int dimension = extent.getDimension();
        block4: for (int dim = 0; dim < dimension; ++dim) {
            long max;
            long min = extent.getLow(dim);
            if (min >= (max = extent.getHigh(dim))) continue;
            switch (++row) {
                case -2: {
                    this.xDimension = dim;
                    continue block4;
                }
                case -1: {
                    this.yDimension = dim;
                    continue block4;
                }
                default: {
                    Converter converter;
                    Slider slider;
                    Label label;
                    if (childrenCount < children.size()) {
                        label = (Label)children.get(childrenCount++);
                        slider = (Slider)children.get(childrenCount++);
                        converter = (Converter)slider.getLabelFormatter();
                    } else {
                        childrenCount += 2;
                        label = new Label();
                        this.view.add((Node)label, 0, row);
                        slider = new Slider();
                        this.view.add((Node)slider, 1, row);
                        slider.setShowTickLabels(true);
                        slider.setShowTickMarks(true);
                        slider.setBlockIncrement(1.0);
                        label.setLabelFor((Node)slider);
                        GridPane.setHgrow((Node)label, (Priority)Priority.NEVER);
                        GridPane.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
                        GridPane.setValignment((Node)label, (VPos)VPos.TOP);
                        converter = new Converter();
                        slider.setLabelFormatter((StringConverter)converter);
                        slider.widthProperty().addListener((p, o, n) -> converter.setTickSpacing(slider, n.doubleValue()));
                        slider.valueProperty().addListener((ChangeListener)converter);
                        slider.valueChangingProperty().addListener((p, o, n) -> converter.setPosition((boolean)n, Math.round(slider.getValue())));
                    }
                    if (row == 0) {
                        vocabulary = Vocabulary.forLocale((Locale)this.locale);
                        if (gg.isDefined(8)) {
                            gridToCRS = new TransformSeparator(gg.getGridToCRS(PixelInCell.CELL_CENTER));
                        }
                        if (gg.isDefined(2)) {
                            envelope = gg.getEnvelope();
                        }
                        if (gg.isDefined(16)) {
                            resolution = gg.getResolution(false);
                        }
                    }
                    slider.setMin((double)min);
                    slider.setMax((double)max);
                    slider.setValue((double)min);
                    selected = selected.withRange(dim, min, min);
                    converter.configure(gg, gridToCRS, dim, min, max, envelope, resolution);
                    converter.setTickSpacing(slider, slider.getWidth());
                    label.setText(vocabulary.toLabel(converter.getAxisLabel(extent, vocabulary)));
                }
            }
        }
        children.remove(childrenCount, children.size());
        this.selectedExtent.set((Object)selected);
    }

    private NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = this.locale != null ? NumberFormat.getNumberInstance(this.locale) : NumberFormat.getNumberInstance();
        }
        return this.numberFormat;
    }

    private DateFormat getDateFormat(boolean verbose, boolean withTime) {
        if (verbose) {
            if (this.longDateFormat == null) {
                this.longDateFormat = this.locale != null ? DateFormat.getDateTimeInstance(1, 1, this.locale) : DateFormat.getDateTimeInstance(1, 1);
            }
            return this.longDateFormat;
        }
        if (withTime) {
            if (this.dateAndTimeFormat == null) {
                this.dateAndTimeFormat = this.locale != null ? DateFormat.getDateTimeInstance(3, 3, this.locale) : DateFormat.getDateTimeInstance(3, 3);
            }
            return this.dateAndTimeFormat;
        }
        if (this.dateFormat == null) {
            this.dateFormat = this.locale != null ? DateFormat.getDateInstance(3, this.locale) : DateFormat.getDateInstance(3);
        }
        return this.dateFormat;
    }

    public final ReadOnlyProperty<GridExtent> selectedExtentProperty() {
        return this.selectedExtent.getReadOnlyProperty();
    }

    public final int[] getXYDimensions() {
        return new int[]{this.xDimension, this.yDimension};
    }

    @Override
    public final Region getView() {
        return this.view;
    }

    public boolean isEmpty() {
        return this.view.getChildren().isEmpty();
    }

    private final class Converter
    extends StringConverter<Double>
    implements ChangeListener<Number> {
        private int dimension;
        private MathTransform1D gridToCRS;
        private CoordinateSystemAxis axis;
        private DefaultTemporalCRS timeCRS;
        private double timeResolutionThreshold;
        private double resolution;
        private double spacingNumerator;
        private String unitName;

        Converter() {
        }

        final void configure(GridGeometry gg, TransformSeparator ts, int dim, double min, double max, Envelope env, double[] res) {
            this.dimension = dim;
            this.gridToCRS = null;
            this.axis = null;
            this.unitName = null;
            this.timeCRS = null;
            this.resolution = 1.0;
            this.timeResolutionThreshold = Double.NaN;
            double span = max - min;
            if (ts != null) {
                try {
                    ts.clear();
                    ts.addSourceDimensions(new int[]{dim});
                    this.gridToCRS = (MathTransform1D)ts.separate();
                    int targetDim = ts.getTargetDimensions()[0];
                    if (gg.isDefined(1)) {
                        Unit unit;
                        CoordinateReferenceSystem crs = gg.getCoordinateReferenceSystem();
                        CoordinateReferenceSystem c = CRS.getComponentAt((CoordinateReferenceSystem)crs, (int)targetDim, (int)(targetDim + 1));
                        this.timeCRS = c instanceof TemporalCRS ? DefaultTemporalCRS.castOrCopy((TemporalCRS)((TemporalCRS)c)) : null;
                        this.axis = crs.getCoordinateSystem().getAxis(targetDim);
                        if (this.timeCRS == null && (unit = this.axis.getUnit()) != null) {
                            Locale locale = GridSliceSelector.this.locale;
                            UnitFormat f = new UnitFormat(locale != null ? locale : Locale.getDefault());
                            f.setStyle(UnitFormat.Style.NAME);
                            this.unitName = " " + f.format(unit);
                        }
                    }
                    if (env != null && res != null && res[targetDim] > 0.0) {
                        this.resolution = res[targetDim];
                        span = env.getSpan(targetDim);
                        if (this.timeCRS != null) {
                            this.timeResolutionThreshold = this.timeCRS.toValue(Duration.ofDays(1L));
                        }
                    }
                }
                catch (ClassCastException | FactoryException e) {
                    Logging.ignorableException((Logger)LogHandler.LOGGER, GridSliceSelector.class, (String)"setGridGeometry", (Throwable)e);
                }
            }
            int length = Math.max(this.toString(min).length(), this.toString(max).length());
            this.spacingNumerator = (double)(length * 10) * span;
        }

        final void setTickSpacing(Slider slider, double width) {
            double spacing = this.spacingNumerator / width;
            spacing = MathFunctions.pow10((double)Math.ceil(Math.log10(spacing)));
            if ((spacing = Math.max(Math.rint(spacing / this.resolution), 1.0)) > 0.0 && spacing < Double.POSITIVE_INFINITY) {
                double minor = Math.max(Math.rint(spacing / 10.0), 1.0);
                long count = Math.max(Math.min(Math.round(spacing / minor), 10L), 1L) - 1L;
                slider.setMinorTickCount((int)count);
                slider.setMajorTickUnit(spacing);
                slider.setSnapToTicks(minor == 1.0);
                if (this.timeCRS != null) {
                    this.timeResolutionThreshold = this.timeCRS.toValue(Duration.ofDays(1L)) / spacing;
                }
            }
        }

        final String getAxisLabel(GridExtent extent, Vocabulary vocabulary) {
            Object label;
            if (this.axis != null && (label = CoordinateSystems.getShortName((CoordinateSystemAxis)this.axis, (Locale)GridSliceSelector.this.locale)) != null) {
                String symbol;
                Unit unit;
                if (this.timeCRS == null && (unit = this.axis.getUnit()) != null && !(symbol = unit.toString()).isEmpty()) {
                    label = (String)label + " (" + symbol + ")";
                }
                return label;
            }
            DimensionNameType axis = extent.getAxisType(this.dimension).orElse(null);
            if (axis != null) {
                return Types.getCodeTitle((CodeList)axis).toString(GridSliceSelector.this.locale);
            }
            return vocabulary.getString((short)269, (Object)this.dimension);
        }

        final void setPosition(boolean adjusting, long position) {
            GridExtent extent;
            StatusBar bar = GridSliceSelector.this.status;
            if (bar != null) {
                bar.setInfoMessage(adjusting ? this.toString(position, true) : null);
            }
            if (!adjusting && (extent = (GridExtent)GridSliceSelector.this.selectedExtent.get()) != null && position != extent.getLow(this.dimension)) {
                GridSliceSelector.this.selectedExtent.set((Object)extent.withRange(this.dimension, position, position));
            }
        }

        public void changed(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
            Slider slider = (Slider)((ReadOnlyProperty)property).getBean();
            this.setPosition(slider.isValueChanging(), Math.round(newValue.doubleValue()));
        }

        private String toString(double value, boolean verbose) {
            int numDigits;
            double derivative;
            if (this.gridToCRS != null) {
                try {
                    value = this.gridToCRS.transform(value);
                    derivative = this.gridToCRS.derivative(value);
                    numDigits = DecimalFunctions.fractionDigitsForDelta((double)derivative, (boolean)false);
                }
                catch (TransformException e) {
                    return "N/A";
                }
            } else {
                derivative = 0.0;
                numDigits = 0;
            }
            if (this.timeCRS != null) {
                DateFormat f = GridSliceSelector.this.getDateFormat(verbose, derivative < this.timeResolutionThreshold);
                return f.format(this.timeCRS.toDate(value));
            }
            NumberFormat f = GridSliceSelector.this.getNumberFormat();
            f.setMinimumFractionDigits(numDigits);
            f.setMaximumFractionDigits(numDigits);
            String text = f.format(value);
            if (verbose && this.unitName != null) {
                text = text.concat(this.unitName);
            }
            return text;
        }

        public String toString(Double index) {
            return this.toString(Math.rint(index), false);
        }

        public Double fromString(String text) {
            double value;
            try {
                value = this.timeCRS != null ? this.timeCRS.toValue(GridSliceSelector.this.getDateFormat(false, true).parse(text)) : GridSliceSelector.this.getNumberFormat().parse(text).doubleValue();
                if (this.gridToCRS != null) {
                    value = this.gridToCRS.inverse().transform(value);
                }
            }
            catch (ParseException | TransformException e) {
                value = Double.NaN;
            }
            return value;
        }
    }
}

