/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server;

import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.log.TimeWaitLogger;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;

public class SofaRejectedExecutionHandler
implements RejectedExecutionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRejectedExecutionHandler.class);
    private final TimeWaitLogger timeWaitLogger = new TimeWaitLogger(1000L);
    private final Consumer<ThreadPoolExecutor> logConsumer = executor -> LOGGER.warn(LogCodes.getLog("020100008", executor.getActiveCount(), executor.getPoolSize(), executor.getLargestPoolSize(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getQueue().size(), executor.getQueue().remainingCapacity()));

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (LOGGER.isWarnEnabled()) {
            this.timeWaitLogger.logWithConsumer(this.logConsumer, executor);
        }
        throw new RejectedExecutionException();
    }
}

