/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter.sofatracer;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.module.SofaTracerModule;

@Extension(value="providerTracer", order=-10000)
@AutoActive(providerSide=true)
public class ProviderTracerFilter
extends Filter {
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        return SofaTracerModule.isEnable();
    }

    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
        if (serverSpan != null) {
            ProviderConfig providerConfig = (ProviderConfig)invoker.getConfig();
            serverSpan.setTag("local.app", providerConfig.getAppName());
        }
        return invoker.invoke(request);
    }
}

