/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.core.request;

import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.RequestBase;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SofaRequest
extends RequestBase {
    private static final long serialVersionUID = 7329530374415722876L;
    private String targetAppName;
    private Map<String, Object> requestProps;
    private transient Method method;
    private transient String interfaceName;
    private transient byte serializeType;
    private transient AbstractByteBuf data;
    private transient String invokeType;
    private transient SofaResponseCallback sofaResponseCallback;
    private transient Integer timeout;

    public Object getRequestProp(String key) {
        return this.requestProps != null ? this.requestProps.get(key) : null;
    }

    public void addRequestProp(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (this.requestProps == null) {
            this.requestProps = new HashMap<String, Object>(16);
        }
        this.requestProps.put(key, value);
    }

    public void removeRequestProp(String key) {
        if (key == null) {
            return;
        }
        if (this.requestProps != null) {
            this.requestProps.remove(key);
        }
    }

    public void addRequestProps(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.requestProps == null) {
            this.requestProps = new HashMap<String, Object>(16);
        }
        this.requestProps.putAll(map);
    }

    public Map<String, Object> getRequestProps() {
        return this.requestProps;
    }

    public String getTargetAppName() {
        return this.targetAppName;
    }

    public void setTargetAppName(String targetAppName) {
        this.targetAppName = targetAppName;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public byte getSerializeType() {
        return this.serializeType;
    }

    public SofaRequest setSerializeType(byte serializeType) {
        this.serializeType = serializeType;
        return this;
    }

    public String getInvokeType() {
        return this.invokeType;
    }

    public SofaRequest setInvokeType(String invokeType) {
        this.invokeType = invokeType;
        return this;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public SofaResponseCallback getSofaResponseCallback() {
        return this.sofaResponseCallback;
    }

    public SofaRequest setSofaResponseCallback(SofaResponseCallback sofaResponseCallback) {
        this.sofaResponseCallback = sofaResponseCallback;
        return this;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public SofaRequest setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public AbstractByteBuf getData() {
        return this.data;
    }

    public SofaRequest setData(AbstractByteBuf data) {
        this.data = data;
        return this;
    }

    public boolean isAsync() {
        return this.invokeType != null && ("callback".equals(this.invokeType) || "future".equals(this.invokeType));
    }
}

