/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ClassUtils {
    public static Class forName(String className) {
        return ClassUtils.forName(className, true);
    }

    public static Class forName(String className, boolean initialize) {
        try {
            return Class.forName(className, initialize, ClassLoaderUtils.getCurrentClassLoader());
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(e);
        }
    }

    public static Class forName(String className, ClassLoader cl) {
        try {
            return Class.forName(className, true, cl);
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(e);
        }
    }

    public static List<Method> getAllMethods(Class clazz) {
        ArrayList<Method> all = new ArrayList<Method>();
        for (Class c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (Modifier.isNative(mod)) continue;
                method.setAccessible(true);
                all.add(method);
            }
        }
        return all;
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> all = new ArrayList<Field>();
        for (Class c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
                field.setAccessible(true);
                all.add(field);
            }
        }
        return all;
    }

    public static <T> T newInstance(Class<T> clazz) throws SofaRpcRuntimeException {
        if (clazz.isPrimitive()) {
            return (T)ClassUtils.getDefaultPrimitiveValue(clazz);
        }
        T t = ClassUtils.getDefaultWrapperValue(clazz);
        if (t != null) {
            return t;
        }
        try {
            Constructor<?>[] constructors;
            if (!clazz.isMemberClass() || Modifier.isStatic(clazz.getModifiers())) {
                try {
                    Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception constructor) {
                    // empty catch block
                }
            }
            if ((constructors = clazz.getDeclaredConstructors()) == null || constructors.length == 0) {
                throw new SofaRpcRuntimeException("The " + clazz.getCanonicalName() + " has no default constructor!");
            }
            Constructor<?> constructor = constructors[0];
            if (constructor.getParameterTypes().length > 0) {
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length < constructor.getParameterTypes().length && (constructor = c).getParameterTypes().length == 0) break;
                }
            }
            constructor.setAccessible(true);
            Class<?>[] argTypes = constructor.getParameterTypes();
            Object[] args = new Object[argTypes.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ClassUtils.getDefaultPrimitiveValue(argTypes[i]);
            }
            return (T)constructor.newInstance(args);
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T newInstanceWithArgs(Class<T> clazz, Class<?>[] argTypes, Object[] args) throws SofaRpcRuntimeException {
        if (CommonUtils.isEmpty(argTypes)) {
            return ClassUtils.newInstance(clazz);
        }
        try {
            if (!clazz.isMemberClass() || Modifier.isStatic(clazz.getModifiers())) {
                Constructor<T> constructor = clazz.getDeclaredConstructor(argTypes);
                constructor.setAccessible(true);
                return constructor.newInstance(args);
            }
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            if (constructors == null || constructors.length == 0) {
                throw new SofaRpcRuntimeException("The " + clazz.getCanonicalName() + " has no constructor with argTypes :" + Arrays.toString(argTypes));
            }
            Constructor<?> constructor = null;
            for (Constructor<?> c : constructors) {
                Class<?>[] ps = c.getParameterTypes();
                if (ps.length != argTypes.length + 1) continue;
                boolean allMath = true;
                for (int i = 1; i < ps.length; ++i) {
                    if (ps[i] == argTypes[i - 1]) continue;
                    allMath = false;
                    break;
                }
                if (!allMath) continue;
                constructor = c;
                break;
            }
            if (constructor == null) {
                throw new SofaRpcRuntimeException("The " + clazz.getCanonicalName() + " has no constructor with argTypes :" + Arrays.toString(argTypes));
            }
            constructor.setAccessible(true);
            Object[] newArgs = new Object[args.length + 1];
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return constructor.newInstance(newArgs);
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }

    public static Object getDefaultPrimitiveValue(Class clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static <T> T getDefaultWrapperValue(Class<T> clazz) {
        if (clazz == Short.class) {
            return (T)Short.valueOf((short)0);
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(0);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(0L);
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(0.0);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(0.0f);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf((byte)0);
        }
        if (clazz == Character.class) {
            return (T)Character.valueOf('\u0000');
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        return null;
    }

    public static String getMethodKey(String interfaceName, String methodName) {
        return interfaceName + "#" + methodName;
    }

    public static boolean isAssignableFrom(Class<?> interfaceClass, Class<?> implementClass) {
        if (interfaceClass.isAssignableFrom(implementClass)) {
            return true;
        }
        String interfaceName = interfaceClass.getCanonicalName();
        return implementClass.getCanonicalName().equals(interfaceName) || ClassUtils.isImplementOrSubclass(interfaceName, implementClass);
    }

    private static boolean isImplementOrSubclass(String interfaceName, Class<?> implementClass) {
        Class<?> superClass;
        Class<?>[] interfaces = implementClass.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> oneInterface : interfaces) {
                if (interfaceName.equals(oneInterface.getCanonicalName())) {
                    return true;
                }
                if (!ClassUtils.isImplementOrSubclass(interfaceName, oneInterface)) continue;
                return true;
            }
        }
        while (!Object.class.equals(implementClass) && (superClass = implementClass.getSuperclass()) != null) {
            implementClass = superClass;
            if (!ClassUtils.isImplementOrSubclass(interfaceName, implementClass)) continue;
            return true;
        }
        return false;
    }
}

