/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.fury.serialize;

import com.alipay.sofa.rpc.codec.CustomSerializer;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import io.fury.ThreadSafeFury;
import io.fury.memory.MemoryBuffer;
import java.util.Map;

public class SofaResponseFurySerializer
implements CustomSerializer<SofaResponse> {
    private final ThreadSafeFury fury;

    public SofaResponseFurySerializer(ThreadSafeFury fury) {
        this.fury = fury;
    }

    @Override
    public AbstractByteBuf encodeObject(SofaResponse object, Map<String, String> context) throws SofaRpcException {
        try {
            MemoryBuffer writeBuffer = MemoryBuffer.newHeapBuffer((int)32);
            writeBuffer.writerIndex(0);
            this.fury.serialize(writeBuffer, (Object)object);
            return new ByteArrayWrapperByteBuf(writeBuffer.getBytes(0, writeBuffer.writerIndex()));
        }
        catch (Exception e) {
            throw new SofaRpcException(130, e.getMessage(), e);
        }
    }

    @Override
    public SofaResponse decodeObject(AbstractByteBuf data, Map<String, String> context) throws SofaRpcException {
        MemoryBuffer readBuffer = MemoryBuffer.fromByteArray((byte[])data.array());
        try {
            boolean genericSerialize;
            boolean bl = genericSerialize = context != null && this.isGenericResponse(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                throw new SofaRpcException(220, "Generic call is not supported for now.");
            }
            return (SofaResponse)this.fury.deserialize(readBuffer);
        }
        catch (Exception e) {
            throw new SofaRpcException(220, e.getMessage(), e);
        }
    }

    @Override
    public void decodeObjectByTemplate(AbstractByteBuf data, Map<String, String> context, SofaResponse template) throws SofaRpcException {
        if (data.readableBytes() <= 0) {
            throw new SofaRpcException(220, "Deserialized array is empty.");
        }
        try {
            boolean genericSerialize;
            MemoryBuffer readBuffer = MemoryBuffer.fromByteArray((byte[])data.array());
            boolean bl = genericSerialize = context != null && this.isGenericResponse(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                throw new SofaRpcException(220, "Generic call is not supported for now.");
            }
            SofaResponse tmp = (SofaResponse)this.fury.deserialize(readBuffer);
            template.setErrorMsg(tmp.getErrorMsg());
            template.setAppResponse(tmp.getAppResponse());
            template.setResponseProps(tmp.getResponseProps());
        }
        catch (Exception e) {
            throw new SofaRpcException(220, e.getMessage(), e);
        }
    }

    protected boolean isGenericResponse(String serializeType) {
        return serializeType != null && serializeType.equals("2");
    }
}

