/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.AbstractServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.nacos.NacosServiceDiscovery;

public class NacosServiceDiscoveryFactory
extends AbstractServiceDiscoveryFactory {
    @Override
    protected String createRegistryCacheKey(URL url) {
        String namespace = url.getParameter("namespace");
        url = URL.valueOf(url.toServiceStringWithoutResolving());
        if (StringUtils.isNotEmpty(namespace)) {
            url = url.addParameter("namespace", namespace);
        }
        return url.toFullString();
    }

    @Override
    protected ServiceDiscovery createDiscovery(URL registryURL) {
        return new NacosServiceDiscovery(this.applicationModel, registryURL);
    }
}

