/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport.util;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanFactory;

public class SpringBeanUtil {
    public static final String COMMA_SPLIT_PATTERN = "\\s*[,]+\\s*";

    public static <T> List<T> getMultiBeans(BeanFactory beanFactory, String names, String pattern, Class<T> clazz) {
        String[] nameArr = names.split(pattern);
        ArrayList<Object> beans = new ArrayList<Object>();
        for (String name : nameArr) {
            if (name == null || name.length() <= 0) continue;
            beans.add(beanFactory.getBean(name, clazz));
        }
        return beans;
    }

    public static void addRegistryParamBean(RegistryConfig registryConfig, BeanFactory beanFactory) {
        Map addressParams;
        String proxyRegistryId;
        if (registryConfig.getProxyRegistry() == null && StringUtils.isNotBlank((CharSequence)(proxyRegistryId = (String)(addressParams = registryConfig.getAddressParams()).get(URLParamType.proxyRegistryId)))) {
            String identity = registryConfig.getId() + "-" + registryConfig.getName();
            RegistryConfig proxyRegistry = (RegistryConfig)beanFactory.getBean(proxyRegistryId, RegistryConfig.class);
            if (proxyRegistry != null) {
                registryConfig.setProxyRegistry(proxyRegistry);
                LoggerUtil.info((String)("add proxy registry bean by address params. proxyRegistryId:" + proxyRegistryId + ", RegistryConfig:" + identity));
            } else {
                LoggerUtil.warn((String)("proxy registry bean not found. proxyRegistryId:" + proxyRegistryId + ", RegistryConfig:" + identity));
            }
        }
    }
}

