/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuServiceInstance;
import org.apache.shenyu.plugin.grpc.transfer.ShenyuServiceTransfer;

public class ShenyuServiceInstanceLists {
    private final List<ShenyuServiceInstance> shenyuServiceInstances = new CopyOnWriteArrayList<ShenyuServiceInstance>();
    private String appName;

    public ShenyuServiceInstanceLists() {
    }

    public ShenyuServiceInstanceLists(String appName) {
        this.appName = appName;
    }

    public ShenyuServiceInstanceLists(List<ShenyuServiceInstance> shenyuServiceInstances, String appName) {
        this.addShenyuServiceInstances(shenyuServiceInstances);
        this.appName = appName;
    }

    public List<ShenyuServiceInstance> getShenyuServiceInstances() {
        return this.shenyuServiceInstances;
    }

    public void addShenyuServiceInstances(List<ShenyuServiceInstance> shenyuServiceInstances) {
        this.shenyuServiceInstances.addAll(shenyuServiceInstances);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public List<ShenyuServiceInstance> getCopyInstances() {
        ArrayList<ShenyuServiceInstance> copy = new ArrayList<ShenyuServiceInstance>(this.shenyuServiceInstances.size());
        this.shenyuServiceInstances.forEach(instance -> {
            ShenyuServiceInstance cp = ShenyuServiceTransfer.INSTANCE.deepCopy((ShenyuServiceInstance)instance);
            copy.add(cp);
        });
        return copy;
    }
}

