/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.util.List;
import java.util.Random;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class P2cLoadBalancer
extends AbstractLoadBalancer {
    private static final int FORCE_GAP = 3000;
    private static final int PENALTY = 250000;
    private static final int PICK_TIMES = 3;
    private final Random random = new Random();

    @Override
    protected Upstream doSelect(List<Upstream> upstreamList, String ip) {
        Upstream unpicked;
        Upstream picked;
        long start = System.currentTimeMillis();
        Upstream[] upstreams = this.pickTwoUpstreams(upstreamList);
        if (this.load(upstreams[0]) > this.load(upstreams[1])) {
            picked = upstreams[1];
            unpicked = upstreams[0];
        } else {
            picked = upstreams[0];
            unpicked = upstreams[1];
        }
        long pick = unpicked.getLastPicked();
        if (start - pick > 3000L) {
            unpicked.setLastPicked(start);
            picked = unpicked;
        }
        if (picked != unpicked) {
            picked.setLastPicked(start);
        }
        picked.getInflight().incrementAndGet();
        return picked;
    }

    private Upstream[] pickTwoUpstreams(List<Upstream> upstreamList) {
        Upstream[] upstreams = new Upstream[2];
        for (int i = 0; i < 3; ++i) {
            int a = this.random.nextInt(upstreamList.size());
            int b = this.random.nextInt(upstreamList.size() - 1);
            if (b >= a) {
                ++b;
            }
            upstreams[0] = upstreamList.get(a);
            upstreams[1] = upstreamList.get(b);
            if (upstreams[0].isHealthy() && upstreams[1].isHealthy()) break;
        }
        return upstreams;
    }

    public long load(Upstream upstream) {
        long lag = (long)(Math.sqrt(upstream.getLag()) + 1.0);
        long load = lag * upstream.getInflight().get();
        if (load == 0L) {
            load = 250000L;
        }
        return load;
    }
}

