/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.config.Language;
import io.fury.memory.MemoryBuffer;
import io.fury.type.TypeUtils;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class Serializer<T> {
    protected final Fury fury;
    protected final Class<T> type;
    protected final boolean isJava;
    protected final boolean needToWriteRef;

    public void write(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException();
    }

    public T read(MemoryBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public short getXtypeId() {
        return 0;
    }

    public String getCrossLanguageTypeTag() {
        throw new UnsupportedOperationException();
    }

    public void xwrite(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException();
    }

    public T xread(MemoryBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public Serializer(Fury fury, Class<T> type) {
        this.fury = fury;
        this.type = type;
        boolean bl = this.isJava = fury.getLanguage() == Language.JAVA;
        this.needToWriteRef = fury.trackingRef() ? !TypeUtils.isBoxed(TypeUtils.wrap(type)) || !fury.isBasicTypesRefIgnored() : false;
    }

    public Serializer(Fury fury, Class<T> type, boolean needToWriteRef) {
        this.fury = fury;
        this.type = type;
        this.isJava = fury.getLanguage() == Language.JAVA;
        this.needToWriteRef = needToWriteRef;
    }

    public final boolean needToWriteRef() {
        return this.needToWriteRef;
    }

    public Class<T> getType() {
        return this.type;
    }
}

