/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.oauth2;

import java.util.Objects;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class OAuth2Plugin
extends AbstractShenyuPlugin {
    private static final String BEARER = "Bearer ";
    private final ObjectProvider<ReactiveOAuth2AuthorizedClientService> authorizedClientServiceProvider;

    public OAuth2Plugin(ObjectProvider<ReactiveOAuth2AuthorizedClientService> authorizedClientServiceProvider) {
        this.authorizedClientServiceProvider = authorizedClientServiceProvider;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        return exchange.getPrincipal().filter(OAuth2AuthenticationToken.class::isInstance).cast(OAuth2AuthenticationToken.class).flatMap(this::buildAuthorizedClient).flatMap(client -> chain.execute(this.writeToken(exchange, (OAuth2AuthorizedClient)client)));
    }

    public int getOrder() {
        return PluginEnum.OAUTH2.getCode();
    }

    public String named() {
        return PluginEnum.OAUTH2.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }

    private Mono<OAuth2AuthorizedClient> buildAuthorizedClient(OAuth2AuthenticationToken oauth2Authentication) {
        String clientRegistrationId = oauth2Authentication.getAuthorizedClientRegistrationId();
        String name = oauth2Authentication.getName();
        ReactiveOAuth2AuthorizedClientService clientService = (ReactiveOAuth2AuthorizedClientService)this.authorizedClientServiceProvider.getIfAvailable();
        if (Objects.isNull(clientService)) {
            return Mono.error((Throwable)new IllegalStateException("ReactiveOAuth2AuthorizedClientService bean was found. you have to add  spring-boot-starter-oauth2-client dependency?"));
        }
        return clientService.loadAuthorizedClient(clientRegistrationId, name);
    }

    private ServerWebExchange writeToken(ServerWebExchange exchange, OAuth2AuthorizedClient client) {
        ServerHttpRequest.Builder mutate = exchange.getRequest().mutate();
        mutate.header("Authorization", new String[]{BEARER + client.getAccessToken().getTokenValue()});
        return exchange.mutate().request(mutate.build()).build();
    }
}

