/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

abstract class InheritableBaseSubscriber<T>
implements CoreSubscriber<T>,
Subscription,
Disposable {
    volatile Subscription subscription;
    static AtomicReferenceFieldUpdater<InheritableBaseSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(InheritableBaseSubscriber.class, Subscription.class, "subscription");

    InheritableBaseSubscriber() {
    }

    protected Subscription upstream() {
        return this.subscription;
    }

    public boolean isDisposed() {
        return this.subscription == Operators.cancelledSubscription();
    }

    public void dispose() {
        this.cancel();
    }

    protected void hookOnSubscribe(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    protected void hookOnNext(T value) {
    }

    protected void hookOnComplete() {
    }

    protected void hookOnError(Throwable throwable) {
        throw Exceptions.errorCallbackNotImplemented((Throwable)throwable);
    }

    protected void hookOnCancel() {
    }

    protected void hookFinally(SignalType type) {
    }

    public void onSubscribe(Subscription s) {
        if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
            try {
                this.hookOnSubscribe(s);
            }
            catch (Throwable throwable) {
                this.onError(Operators.onOperatorError((Subscription)s, (Throwable)throwable, (Context)this.currentContext()));
            }
        }
    }

    public void onNext(T value) {
        Objects.requireNonNull(value, "onNext");
        try {
            this.hookOnNext(value);
        }
        catch (Throwable throwable) {
            this.onError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)throwable, value, (Context)this.currentContext()));
        }
    }

    protected boolean shouldCallErrorDropHook() {
        return true;
    }

    public void onError(Throwable t) {
        Objects.requireNonNull(t, "onError");
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            if (this.shouldCallErrorDropHook()) {
                Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            }
            return;
        }
        try {
            this.hookOnError(t);
        }
        catch (Throwable e) {
            e = Exceptions.addSuppressed((Throwable)e, (Throwable)t);
            Operators.onErrorDropped((Throwable)e, (Context)this.currentContext());
        }
        finally {
            this.safeHookFinally(SignalType.ON_ERROR);
        }
    }

    public void onComplete() {
        if (S.getAndSet(this, Operators.cancelledSubscription()) != Operators.cancelledSubscription()) {
            try {
                this.hookOnComplete();
            }
            catch (Throwable throwable) {
                this.hookOnError(Operators.onOperatorError((Throwable)throwable, (Context)this.currentContext()));
            }
            finally {
                this.safeHookFinally(SignalType.ON_COMPLETE);
            }
        }
    }

    public final void request(long n) {
        Subscription s;
        if (Operators.validate((long)n) && (s = this.subscription) != null) {
            s.request(n);
        }
    }

    public final void requestUnbounded() {
        this.request(Long.MAX_VALUE);
    }

    public final void cancel() {
        if (Operators.terminate(S, (Object)this)) {
            try {
                this.hookOnCancel();
            }
            catch (Throwable throwable) {
                this.hookOnError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)throwable, (Context)this.currentContext()));
            }
            finally {
                this.safeHookFinally(SignalType.CANCEL);
            }
        }
    }

    void safeHookFinally(SignalType type) {
        try {
            this.hookFinally(type);
        }
        catch (Throwable finallyFailure) {
            Operators.onErrorDropped((Throwable)finallyFailure, (Context)this.currentContext());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

