/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.composite;

import com.alipay.common.tracer.core.reporter.facade.AbstractReporter;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SofaTracerCompositeDigestReporterImpl
extends AbstractReporter {
    private Map<String, Reporter> compositedReporters = new ConcurrentHashMap<String, Reporter>();

    public synchronized boolean addReporter(Reporter reporter) {
        if (reporter == null) {
            return false;
        }
        String reporterType = reporter.getReporterType();
        if (this.compositedReporters.containsKey(reporterType)) {
            return false;
        }
        this.compositedReporters.put(reporterType, reporter);
        return true;
    }

    @Override
    public String getReporterType() {
        return "COMPOSITE_REPORTER";
    }

    @Override
    public void doReport(SofaTracerSpan span) {
        for (Map.Entry<String, Reporter> entry : this.compositedReporters.entrySet()) {
            Reporter reporter = entry.getValue();
            reporter.report(span);
        }
    }
}

