/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.loadbalancer.random;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.utils.CollectionUtils;
import java.util.List;
import java.util.Random;

public class WeightedRandomBalance
extends Destroyable
implements LoadBalancer {
    private final Random random = new Random();

    @Override
    public Instance chooseInstance(Criteria criteria, ServiceInstances svcInstances) throws PolarisException {
        int totalWeight = svcInstances.getTotalWeight();
        if (totalWeight <= 0) {
            totalWeight = this.sumTotalWeight(svcInstances);
        }
        if (totalWeight == 0) {
            throw new PolarisException(ErrorCode.INSTANCE_NOT_FOUND, String.format("all instances weight 0 for %s:%s", svcInstances.getNamespace(), svcInstances.getService()));
        }
        List<Instance> instances = svcInstances.getInstances();
        int randomValue = Math.abs(this.random.nextInt() % totalWeight);
        int start = 0;
        int end = 0;
        for (Instance instance : instances) {
            if (randomValue >= start && randomValue < (end += instance.getWeight())) {
                return instance;
            }
            start = end;
        }
        return instances.get(totalWeight % instances.size());
    }

    private int sumTotalWeight(ServiceInstances svcInstances) {
        List<Instance> instances = svcInstances.getInstances();
        int totalWeight = 0;
        if (CollectionUtils.isNotEmpty(instances)) {
            for (Instance instance : instances) {
                totalWeight += instance.getWeight();
            }
        }
        return totalWeight;
    }

    @Override
    public String getName() {
        return "weightedRandom";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.LOAD_BALANCER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) {
    }

    @Override
    public void postContextInit(Extensions extensions) throws PolarisException {
    }
}

