/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.enhanced.service;

import java.time.Duration;
import java.util.Optional;
import org.apache.shenyu.plugin.ai.common.strategy.SimpleModelFallbackStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.retry.NonTransientAiException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class AiProxyExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyExecutorService.class);

    public Mono<ChatResponse> execute(ChatClient mainClient, Optional<ChatClient> fallbackClientOpt, String requestBody) {
        Mono<ChatResponse> mainCall = this.doChatCall(mainClient, requestBody);
        return mainCall.retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(1L)).filter(throwable -> !(throwable instanceof NonTransientAiException)).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            LOG.warn("Retries exhausted for AI call after {} attempts.", (Object)retrySignal.totalRetries(), (Object)retrySignal.failure());
            return new NonTransientAiException("Retries exhausted. Triggering fallback.", retrySignal.failure());
        })).onErrorResume(NonTransientAiException.class, throwable -> this.handleFallback((Throwable)throwable, fallbackClientOpt, requestBody));
    }

    protected Mono<ChatResponse> doChatCall(ChatClient client, String requestBody) {
        return Mono.fromCallable(() -> client.prompt().user(requestBody).call().chatResponse()).subscribeOn(Schedulers.boundedElastic());
    }

    private Mono<ChatResponse> handleFallback(Throwable throwable, Optional<ChatClient> fallbackClientOpt, String requestBody) {
        LOG.warn("AI main call failed or retries exhausted, attempting to fallback...", throwable);
        if (fallbackClientOpt.isEmpty()) {
            return Mono.error((Throwable)throwable);
        }
        return SimpleModelFallbackStrategy.INSTANCE.fallback(fallbackClientOpt.get(), requestBody, throwable);
    }

    public Flux<ChatResponse> executeStream(ChatClient mainClient, Optional<ChatClient> fallbackClientOpt, String requestBody) {
        Flux<ChatResponse> mainStream = this.doChatStream(mainClient, requestBody);
        return mainStream.retryWhen((Retry)Retry.max((long)1L).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            LOG.warn("Retrying stream once failed. Attempts: {}. Triggering fallback.", (Object)retrySignal.totalRetries(), (Object)retrySignal.failure());
            return new NonTransientAiException("Stream failed after 1 retry. Triggering fallback.", retrySignal.failure());
        })).onErrorResume(NonTransientAiException.class, throwable -> this.handleFallbackStream((Throwable)throwable, fallbackClientOpt, requestBody));
    }

    protected Flux<ChatResponse> doChatStream(ChatClient client, String requestBody) {
        return Flux.defer(() -> client.prompt().user(requestBody).stream().chatResponse()).subscribeOn(Schedulers.boundedElastic());
    }

    private Flux<ChatResponse> handleFallbackStream(Throwable throwable, Optional<ChatClient> fallbackClientOpt, String requestBody) {
        LOG.warn("AI main stream failed or retries exhausted, attempting to fallback...", throwable);
        if (fallbackClientOpt.isEmpty()) {
            return Flux.error((Throwable)throwable);
        }
        return SimpleModelFallbackStrategy.INSTANCE.fallbackStream(fallbackClientOpt.get(), requestBody, throwable);
    }
}

