/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.disruptor.subcriber;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.client.core.shutdown.ShenyuClientShutdownHook;
import org.apache.shenyu.client.core.shutdown.ShutdownHookManager;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.SystemInfoUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ShenyuClientURIExecutorSubscriber
implements ExecutorTypeSubscriber<URIRegisterDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClientURIExecutorSubscriber.class);
    private static final List<URIRegisterDTO> URIS = Lists.newArrayList();
    private final ShenyuClientRegisterRepository shenyuClientRegisterRepository;
    private final ScheduledThreadPoolExecutor executor;

    public ShenyuClientURIExecutorSubscriber(ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        this.shenyuClientRegisterRepository = shenyuClientRegisterRepository;
        ThreadFactory requestFactory = ShenyuThreadFactory.create((String)"heartbeat-reporter", (boolean)true);
        this.executor = new ScheduledThreadPoolExecutor(1, requestFactory);
        this.executor.scheduleAtFixedRate(() -> URIS.forEach(this::sendHeartbeat), 30L, 10L, TimeUnit.SECONDS);
    }

    public DataType getType() {
        return DataType.URI;
    }

    public void executor(Collection<URIRegisterDTO> dataList) {
        for (URIRegisterDTO uriRegisterDTO : dataList) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            while (true) {
                try {
                    Socket ignored = new Socket(uriRegisterDTO.getHost(), (int)uriRegisterDTO.getPort());
                    ignored.close();
                }
                catch (IOException e) {
                    long sleepTime = 1000L;
                    if (stopwatch.elapsed(TimeUnit.SECONDS) > 5L) {
                        LOG.error("host:{}, port:{} connection failed, will retry", (Object)uriRegisterDTO.getHost(), (Object)uriRegisterDTO.getPort());
                        if (stopwatch.elapsed(TimeUnit.SECONDS) > 180L) {
                            sleepTime = 10000L;
                        }
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(sleepTime);
                    }
                    catch (InterruptedException ex) {
                        LOG.error("interrupted when sleep", (Throwable)ex);
                    }
                    continue;
                }
                break;
            }
            ShenyuClientShutdownHook.delayOtherHooks();
            this.shenyuClientRegisterRepository.persistURI(uriRegisterDTO);
            URIS.add(uriRegisterDTO);
            ShutdownHookManager.get().addShutdownHook(new Thread(() -> {
                URIRegisterDTO offlineDTO = new URIRegisterDTO();
                BeanUtils.copyProperties((Object)uriRegisterDTO, (Object)offlineDTO);
                offlineDTO.setEventType(EventType.OFFLINE);
                this.shenyuClientRegisterRepository.offline(offlineDTO);
                if (!this.executor.isTerminated()) {
                    this.executor.shutdown();
                }
            }), 2);
        }
    }

    private void sendHeartbeat(URIRegisterDTO uriRegisterDTO) {
        uriRegisterDTO.setInstanceInfo(SystemInfoUtils.getSystemInfo());
        this.shenyuClientRegisterRepository.sendHeartbeat(uriRegisterDTO);
    }
}

