/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rabbitmq.conllector;

import java.util.Objects;
import org.apache.shenyu.plugin.logging.common.collector.AbstractLogCollector;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.desensitize.api.matcher.KeyWordMatch;
import org.apache.shenyu.plugin.logging.rabbitmq.cache.RabbitmqClientCache;
import org.apache.shenyu.plugin.logging.rabbitmq.client.RabbitmqLogCollectClient;
import org.apache.shenyu.plugin.logging.rabbitmq.config.RabbitmqLogCollectConfig;
import org.apache.shenyu.plugin.logging.rabbitmq.handler.LoggingRabbitmqPluginDataHandler;

public class RabbitmqLogCollector
extends AbstractLogCollector<RabbitmqLogCollectClient, ShenyuRequestLog, RabbitmqLogCollectConfig.RabbitmqLogConfig> {
    private static final LogCollector<ShenyuRequestLog> INSTANCE = new RabbitmqLogCollector();

    public static LogCollector<ShenyuRequestLog> getInstance() {
        return INSTANCE;
    }

    public RabbitmqLogCollectClient getLogConsumeClient() {
        return LoggingRabbitmqPluginDataHandler.getRabbitmqLogCollectClient();
    }

    public RabbitmqLogCollectClient getLogConsumeClient(String path) {
        RabbitmqLogCollectClient rabbitmqClient = RabbitmqClientCache.getInstance().getRabbitmqClient(path);
        if (Objects.isNull((Object)rabbitmqClient)) {
            return this.getLogConsumeClient();
        }
        return rabbitmqClient;
    }

    protected boolean getMultiClient() {
        return LoggingRabbitmqPluginDataHandler.getMultiClient();
    }

    protected RabbitmqLogCollectConfig.RabbitmqLogConfig getLogCollectConfig() {
        return RabbitmqLogCollectConfig.INSTANCE.getRabbitmqLogConfig();
    }

    protected void desensitizeLog(ShenyuRequestLog log, KeyWordMatch keyWordMatch, String desensitizeAlg) {
    }
}

