/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.base.cache.CommonPluginDataSubscriber;
import org.apache.shenyu.web.handler.ShenyuWebHandler;
import org.apache.shenyu.web.loader.PluginJarParser;
import org.apache.shenyu.web.loader.ShenyuExtPathPluginJarLoader;
import org.apache.shenyu.web.loader.ShenyuLoaderResult;
import org.apache.shenyu.web.loader.ShenyuPluginClassLoader;
import org.apache.shenyu.web.loader.ShenyuPluginClassLoaderHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuLoaderService {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuLoaderService.class);
    private final ShenyuWebHandler webHandler;
    private final CommonPluginDataSubscriber subscriber;
    private final ShenyuConfig shenyuConfig;

    public ShenyuLoaderService(ShenyuWebHandler webHandler, CommonPluginDataSubscriber subscriber, ShenyuConfig shenyuConfig) {
        this.subscriber = subscriber;
        this.webHandler = webHandler;
        this.shenyuConfig = shenyuConfig;
        ShenyuConfig.ExtPlugin config = shenyuConfig.getExtPlugin();
        if (config.getEnabled()) {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor((int)config.getThreads(), ShenyuThreadFactory.create((String)"plugin-ext-loader", (boolean)true));
            executor.scheduleAtFixedRate(() -> this.loadExtOrUploadPlugins(null), config.getScheduleDelay().intValue(), config.getScheduleTime().intValue(), TimeUnit.SECONDS);
        }
    }

    public void loadExtOrUploadPlugins(PluginData uploadedJarResource) {
        try {
            ArrayList<ShenyuLoaderResult> plugins = new ArrayList<ShenyuLoaderResult>();
            ShenyuPluginClassLoaderHolder singleton = ShenyuPluginClassLoaderHolder.getSingleton();
            if (Objects.isNull(uploadedJarResource)) {
                List<PluginJarParser.PluginJar> uploadPluginJars = ShenyuExtPathPluginJarLoader.loadExtendPlugins(this.shenyuConfig.getExtPlugin().getPath());
                for (PluginJarParser.PluginJar extPath : uploadPluginJars) {
                    LOG.info("shenyu extPlugin find new {} to load", (Object)extPath.getAbsolutePath());
                    ShenyuPluginClassLoader extPathClassLoader = singleton.createPluginClassLoader(extPath);
                    plugins.addAll(extPathClassLoader.loadUploadedJarPlugins());
                }
            } else {
                PluginJarParser.PluginJar pluginJar = PluginJarParser.parseJar(Base64.getDecoder().decode(uploadedJarResource.getPluginJar()));
                LOG.info("shenyu upload plugin jar find new {} to load", (Object)pluginJar.getJarKey());
                ShenyuPluginClassLoader uploadPluginClassLoader = singleton.createPluginClassLoader(pluginJar);
                plugins.addAll(uploadPluginClassLoader.loadUploadedJarPlugins());
            }
            this.loaderPlugins(plugins);
        }
        catch (Exception e) {
            LOG.error("shenyu plugins load has error ", (Throwable)e);
        }
    }

    private void loaderPlugins(List<ShenyuLoaderResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return;
        }
        List<ShenyuPlugin> shenyuExtendPlugins = results.stream().map(ShenyuLoaderResult::getShenyuPlugin).filter(Objects::nonNull).collect(Collectors.toList());
        this.webHandler.putExtPlugins(shenyuExtendPlugins);
        List handlers = results.stream().map(ShenyuLoaderResult::getPluginDataHandler).filter(Objects::nonNull).collect(Collectors.toList());
        this.subscriber.putExtendPluginDataHandler(handlers);
    }
}

