/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.context.impl;

import com.qq.tars.context.DistributedContext;
import com.qq.tars.context.impl.ContextItem;
import java.util.Map;
import java.util.Set;

public class DistributedContextImpl
implements DistributedContext {
    private static ThreadLocal<ContextItem> contexts = new ThreadLocal<ContextItem>(){

        @Override
        protected ContextItem initialValue() {
            return new ContextItem();
        }
    };

    @Override
    public void clear() {
        contexts.remove();
    }

    @Override
    public <T> T get(String name) {
        try {
            ContextItem item = this.getItem();
            Object value = item.getAttribute(name);
            return (T)(value != null ? value : null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<String> keySet() {
        return this.getItem().getMap().keySet();
    }

    @Override
    public <T> void put(String name, T value) {
        this.getItem().setAttribute(name, value);
    }

    @Override
    public int size() {
        return this.getItem().getMap().size();
    }

    private ContextItem getItem() {
        ContextItem item = contexts.get();
        if (item == null) {
            item = new ContextItem();
            contexts.set(item);
        }
        return item;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.getItem().getMap();
    }
}

