/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.transformer.request.cache;

import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;

public class ChatClientCache {
    private static final Map<String, ChatClient> CHAT_CLIENT_MAP = new HashMap<String, ChatClient>();

    public ChatClient init(String ruleId, ChatModel chatModel) {
        ChatClient chatClient = ChatClient.builder((ChatModel)chatModel).build();
        CHAT_CLIENT_MAP.put(ruleId, chatClient);
        return chatClient;
    }

    public static ChatClientCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public ChatClient getClient(String key) {
        return CHAT_CLIENT_MAP.get(key);
    }

    public void destroyClient(String key) {
        CHAT_CLIENT_MAP.remove(key);
    }

    static final class ApplicationConfigCacheInstance {
        static final ChatClientCache INSTANCE = new ChatClientCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

