/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data.array;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseIntArrayValue
extends ClickHouseObjectValue<int[]> {
    private static final String TYPE_NAME = "int[]";

    public static ClickHouseIntArrayValue ofEmpty() {
        return ClickHouseIntArrayValue.of(ClickHouseValues.EMPTY_INT_ARRAY);
    }

    public static ClickHouseIntArrayValue of(int[] value) {
        return ClickHouseIntArrayValue.of(null, value);
    }

    public static ClickHouseIntArrayValue of(ClickHouseValue ref, int[] value) {
        return ref instanceof ClickHouseIntArrayValue ? ((ClickHouseIntArrayValue)ref).set(value) : new ClickHouseIntArrayValue(value);
    }

    protected ClickHouseIntArrayValue(int[] value) {
        super(value);
    }

    protected ClickHouseIntArrayValue set(int[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        int[] v = (int[])this.getValue();
        int len = v.length;
        Object[] array = new Integer[len];
        for (int i = 0; i < len; ++i) {
            array[i] = v[i];
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        int[] v = (int[])this.getValue();
        int len = v.length;
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(v[i]);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        int[] v = (int[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(v[i]));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.toString((int[])this.getValue());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseIntArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseIntArrayValue((int[])this.getValue());
        }
        int[] value = (int[])this.getValue();
        return new ClickHouseIntArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((int[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseIntArrayValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_INT_ARRAY);
        return this;
    }

    @Override
    public ClickHouseIntArrayValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        int len;
        int[] value = (int[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (int i = 0; i < len; ++i) {
            builder.append(value[i]).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseIntArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] ? 1 : 0;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(byte value) {
        return this.set(new int[]{value});
    }

    @Override
    public ClickHouseIntArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(short value) {
        return this.set(new int[]{value});
    }

    @Override
    public ClickHouseIntArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(int value) {
        return this.set(new int[]{value});
    }

    @Override
    public ClickHouseIntArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Arrays.copyOf(value, len));
    }

    @Override
    public ClickHouseIntArrayValue update(long value) {
        return this.set(new int[]{(int)value});
    }

    @Override
    public ClickHouseIntArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (int)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(float value) {
        return this.set(new int[]{(int)value});
    }

    @Override
    public ClickHouseIntArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (int)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(double value) {
        return this.set(new int[]{(int)value});
    }

    @Override
    public ClickHouseIntArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (int)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(BigInteger value) {
        int[] nArray;
        if (value == null) {
            nArray = ClickHouseValues.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = value.intValue();
        }
        return this.set(nArray);
    }

    @Override
    public ClickHouseIntArrayValue update(BigDecimal value) {
        int[] nArray;
        if (value == null) {
            nArray = ClickHouseValues.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = value.intValue();
        }
        return this.set(nArray);
    }

    @Override
    public ClickHouseIntArrayValue update(Enum<?> value) {
        int[] nArray;
        if (value == null) {
            nArray = ClickHouseValues.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = value.ordinal();
        }
        return this.set(nArray);
    }

    @Override
    public ClickHouseIntArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseIntArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseIntArrayValue update(LocalDate value) {
        int[] nArray;
        if (value == null) {
            nArray = ClickHouseValues.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = (int)value.toEpochDay();
        }
        return this.set(nArray);
    }

    @Override
    public ClickHouseIntArrayValue update(LocalTime value) {
        int[] nArray;
        if (value == null) {
            nArray = ClickHouseValues.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = value.toSecondOfDay();
        }
        return this.set(nArray);
    }

    @Override
    public ClickHouseIntArrayValue update(LocalDateTime value) {
        int[] nArray;
        if (value == null) {
            nArray = ClickHouseValues.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = (int)value.toEpochSecond(ZoneOffset.UTC);
        }
        return this.set(nArray);
    }

    @Override
    public ClickHouseIntArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o == null ? 0 : ((Number)o).intValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        int[] values = new int[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n == null ? 0 : n.intValue();
        }
        return this.set(values);
    }

    @Override
    public ClickHouseIntArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] v = new int[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o == null ? 0 : ((Number)e.getValue()).intValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseIntArrayValue update(String value) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            this.set(ClickHouseValues.EMPTY_INT_ARRAY);
        } else {
            List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
            if (list.isEmpty()) {
                this.set(ClickHouseValues.EMPTY_INT_ARRAY);
            } else {
                int[] arr = new int[list.size()];
                int index = 0;
                for (String v : list) {
                    arr[index++] = v == null ? 0 : Integer.parseInt(v);
                }
                this.set(arr);
            }
        }
        return this;
    }

    @Override
    public ClickHouseIntArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseIntArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseIntArrayValue) {
            this.set((int[])((ClickHouseIntArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseIntArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            Object o = value[i];
            values[i] = o == null ? 0 : ((Number)o).intValue();
        }
        this.set(values);
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new int[]{((Number)value).intValue()});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseIntArrayValue update(Object value) {
        if (value instanceof int[]) {
            this.set((int[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((int[])this.getValue(), (int[])((ClickHouseIntArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((int[])this.getValue());
    }
}

