/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.NamedThreadFactory;
import com.alipay.sofa.common.thread.ThreadPoolConfig;
import com.alipay.sofa.common.thread.ThreadPoolMonitorWrapper;
import com.alipay.sofa.common.thread.ThreadPoolStatistics;
import com.alipay.sofa.common.thread.log.ThreadLogger;
import com.alipay.sofa.common.thread.space.ThreadPoolSpace;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolGovernor {
    private static final ThreadPoolGovernor INSTANCE = new ThreadPoolGovernor();
    public static String CLASS_NAME = ThreadPoolGovernor.class.getCanonicalName();
    private final ScheduledExecutorService governorScheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("SOFA-Thread-Pool-Governor"));
    private final ScheduledExecutorService monitorScheduler = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() + 1, new NamedThreadFactory("SOFA-Thread-Pool-Monitor"));
    private final Object monitor = new Object();
    private final GovernorInfoDumper governorInfoDumper = new GovernorInfoDumper();
    private final ConcurrentHashMap<String, ThreadPoolMonitorWrapper> registry = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ThreadPoolSpace> spaceNameMap = new ConcurrentHashMap();
    private volatile long governorPeriod = 30L;
    private volatile boolean governorLoggable = false;
    private volatile boolean globalMonitorLoggable = true;
    private ScheduledFuture<?> governorScheduledFuture;

    private ThreadPoolGovernor() {
    }

    public static ThreadPoolGovernor getInstance() {
        return INSTANCE;
    }

    public synchronized void startGovernorSchedule() {
        if (this.governorScheduledFuture == null) {
            this.governorScheduledFuture = this.governorScheduler.scheduleAtFixedRate(this.governorInfoDumper, this.governorPeriod, this.governorPeriod, TimeUnit.SECONDS);
            ThreadLogger.info("Started {} with period: {} SECONDS", CLASS_NAME, this.governorPeriod);
        } else {
            ThreadLogger.warn("{} has already started with period: {} SECONDS.", CLASS_NAME, this.governorPeriod);
        }
    }

    public synchronized void stopGovernorSchedule() {
        if (this.governorScheduledFuture != null) {
            this.governorScheduledFuture.cancel(true);
            this.governorScheduledFuture = null;
            ThreadLogger.info("Stopped {}.", CLASS_NAME);
        } else {
            ThreadLogger.warn("{} is not scheduling!", CLASS_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartGovernorSchedule() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.governorScheduledFuture != null) {
                this.governorScheduledFuture.cancel(true);
                this.governorScheduledFuture = this.governorScheduler.scheduleAtFixedRate(this.governorInfoDumper, this.governorPeriod, this.governorPeriod, TimeUnit.SECONDS);
                ThreadLogger.info("Reschedule {} with period: {} SECONDS", CLASS_NAME, this.governorPeriod);
            }
        }
    }

    public long getGovernorPeriod() {
        return this.governorPeriod;
    }

    public void setGovernorPeriod(long governorPeriod) {
        this.governorPeriod = governorPeriod;
        this.restartGovernorSchedule();
    }

    public boolean isGovernorLoggable() {
        return this.governorLoggable;
    }

    public void setGovernorLoggable(boolean governorLoggable) {
        this.governorLoggable = governorLoggable;
    }

    public boolean isGlobalMonitorLoggable() {
        return this.globalMonitorLoggable;
    }

    public void setGlobalMonitorLoggable(boolean globalMonitorLoggable) {
        this.globalMonitorLoggable = globalMonitorLoggable;
    }

    public void registerThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor, ThreadPoolConfig threadPoolConfig, ThreadPoolStatistics threadPoolStatistics) {
        String identity = threadPoolConfig.getIdentity();
        if (StringUtil.isEmpty(identity)) {
            ThreadLogger.error("Rejected registering request of instance {} with empty name: {}.", threadPoolExecutor, identity);
            return;
        }
        ThreadPoolMonitorWrapper threadPoolMonitorWrapper = new ThreadPoolMonitorWrapper(threadPoolExecutor, threadPoolConfig, threadPoolStatistics);
        if (this.registry.putIfAbsent(identity, threadPoolMonitorWrapper) != null) {
            ThreadLogger.error("Rejected registering request of instance {} with duplicate name: {}", threadPoolExecutor, identity);
        } else {
            this.registry.get(identity).startMonitor();
            ThreadLogger.info("Thread pool with name '{}' registered", identity);
            String spaceName = threadPoolConfig.getSpaceName();
            if (StringUtil.isNotEmpty(spaceName)) {
                this.spaceNameMap.computeIfAbsent(spaceName, k -> new ThreadPoolSpace()).addThreadPool(identity);
            }
        }
    }

    public void unregisterThreadPoolExecutor(ThreadPoolConfig threadPoolConfig) {
        String spaceName;
        String identity = threadPoolConfig.getIdentity();
        if (StringUtil.isEmpty(identity)) {
            ThreadLogger.error("Thread pool with empty name unregistered, may cause memory leak", new Object[0]);
            return;
        }
        ThreadPoolMonitorWrapper threadPoolMonitorWrapper = this.registry.remove(identity);
        if (threadPoolMonitorWrapper != null) {
            threadPoolMonitorWrapper.stopMonitor();
            ThreadLogger.info("Thread pool with name '{}' unregistered", identity);
        }
        if (StringUtil.isNotEmpty(spaceName = threadPoolConfig.getSpaceName()) && this.spaceNameMap.get(spaceName) != null) {
            this.spaceNameMap.get(spaceName).removeThreadPool(identity);
        }
    }

    public ThreadPoolExecutor getThreadPoolExecutor(String identity) {
        ThreadPoolMonitorWrapper wrapper = this.registry.get(identity);
        if (wrapper == null) {
            ThreadLogger.warn("Thread pool '{}' is not registered yet", identity);
            return null;
        }
        return wrapper.getThreadPoolExecutor();
    }

    public ThreadPoolMonitorWrapper getThreadPoolMonitorWrapper(String identity) {
        ThreadPoolMonitorWrapper wrapper = this.registry.get(identity);
        if (wrapper == null) {
            ThreadLogger.warn("Thread pool '{}' is not registered yet", identity);
            return null;
        }
        return wrapper;
    }

    public void startMonitorThreadPool(String identity) {
        ThreadPoolMonitorWrapper wrapper = this.registry.get(identity);
        if (wrapper == null) {
            ThreadLogger.warn("Thread pool '{}' is not registered yet", identity);
            return;
        }
        wrapper.startMonitor();
    }

    public void stopMonitorThreadPool(String identity) {
        ThreadPoolMonitorWrapper wrapper = this.registry.get(identity);
        if (wrapper == null) {
            ThreadLogger.warn("Thread pool '{}' is not registered yet", identity);
            return;
        }
        wrapper.stopMonitor();
    }

    public void restartMonitorThreadPool(String identity) {
        ThreadPoolMonitorWrapper wrapper = this.registry.get(identity);
        if (wrapper == null) {
            ThreadLogger.warn("Thread pool '{}' is not registered yet", identity);
            return;
        }
        wrapper.restartMonitor();
    }

    public ScheduledExecutorService getMonitorScheduler() {
        return this.monitorScheduler;
    }

    public int getSpaceNameThreadPoolNumber(String spaceName) {
        ThreadPoolSpace threadPoolSpace = this.spaceNameMap.get(spaceName);
        if (threadPoolSpace == null) {
            ThreadLogger.error("Thread pool with spaceName '{}' is not registered yet, return 0", spaceName);
            return 0;
        }
        return threadPoolSpace.getThreadPoolNumber();
    }

    public void startMonitorThreadPoolBySpaceName(String spaceName) {
        ThreadPoolSpace threadPoolSpace = this.spaceNameMap.get(spaceName);
        if (threadPoolSpace == null || threadPoolSpace.getThreadPoolIdentities().isEmpty()) {
            ThreadLogger.error("Thread pool with spaceName '{}' is not registered yet", spaceName);
            return;
        }
        threadPoolSpace.getThreadPoolIdentities().forEach(this::startMonitorThreadPool);
        ThreadLogger.info("Thread pool with spaceName '{}' started", spaceName);
    }

    public void stopMonitorThreadPoolBySpaceName(String spaceName) {
        ThreadPoolSpace threadPoolSpace = this.spaceNameMap.get(spaceName);
        if (threadPoolSpace == null || threadPoolSpace.getThreadPoolIdentities().isEmpty()) {
            ThreadLogger.error("Thread pool with spaceName '{}' is not registered yet", spaceName);
            return;
        }
        threadPoolSpace.getThreadPoolIdentities().forEach(this::stopMonitorThreadPool);
        ThreadLogger.info("Thread pool with spaceName '{}' stopped", spaceName);
    }

    public void setMonitorThreadPoolBySpaceName(String spaceName, long period) {
        ThreadPoolSpace threadPoolSpace = this.spaceNameMap.get(spaceName);
        if (threadPoolSpace == null || threadPoolSpace.getThreadPoolIdentities().isEmpty()) {
            ThreadLogger.error("Thread pool with spaceName '{}' is not registered yet", spaceName);
            return;
        }
        threadPoolSpace.getThreadPoolIdentities().forEach(identity -> {
            ThreadPoolMonitorWrapper wrapper = this.getThreadPoolMonitorWrapper((String)identity);
            if (wrapper != null) {
                wrapper.getThreadPoolConfig().setPeriod(period);
                this.restartMonitorThreadPool((String)identity);
            }
        });
        ThreadLogger.info("Thread pool with spaceName '{}' rescheduled with period '{}'", spaceName, period);
    }

    public Collection<ThreadPoolMonitorWrapper> getAllThreadPoolWrappers() {
        return new ArrayList<ThreadPoolMonitorWrapper>(this.registry.values());
    }

    class GovernorInfoDumper
    implements Runnable {
        GovernorInfoDumper() {
        }

        @Override
        public void run() {
            try {
                if (ThreadPoolGovernor.this.governorLoggable) {
                    for (Map.Entry<String, ThreadPoolMonitorWrapper> entry : ThreadPoolGovernor.this.registry.entrySet()) {
                        ThreadLogger.info("Thread pool '{}' exists with instance: {}", entry.getKey(), entry.getValue().getThreadPoolExecutor());
                    }
                }
            }
            catch (Throwable e) {
                ThreadLogger.warn("{} is interrupted when running: {}", this, e);
            }
        }
    }
}

