/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.config;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.MessageSizeEstimator;
import java.util.Objects;

public class NettyChannelProperties {
    private static final String UN_POOLED = "unpooled";
    private static final String POOLED = "pooled";
    private Integer connectTimeoutMillis = 10000;
    private Integer writeBufferHighWaterMark = 65536;
    private Integer writeBufferLowWaterMark = 32768;
    private Integer writeSpinCount = 16;
    private Boolean autoRead = false;
    private String allocType = "pooled";
    private Boolean soReuseAddr = false;
    private Integer messageSizeEstimator = 8;
    private Boolean singleEventExecutorPerGroup = true;

    public Integer getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(Integer connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public Integer getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public void setWriteBufferHighWaterMark(Integer writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    public Integer getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public void setWriteBufferLowWaterMark(Integer writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public Integer getWriteSpinCount() {
        return this.writeSpinCount;
    }

    public void setWriteSpinCount(Integer writeSpinCount) {
        this.writeSpinCount = writeSpinCount;
    }

    public Boolean isAutoRead() {
        return this.autoRead;
    }

    public void setAutoRead(Boolean autoRead) {
        this.autoRead = autoRead;
    }

    public ByteBufAllocator getAllocator() {
        return UN_POOLED.equals(this.getAllocType()) ? UnpooledByteBufAllocator.DEFAULT : PooledByteBufAllocator.DEFAULT;
    }

    public String getAllocType() {
        return this.allocType;
    }

    public void setAllocType(String allocType) {
        this.allocType = allocType;
    }

    public Boolean isSoReuseAddr() {
        return this.soReuseAddr;
    }

    public void setSoReuseAddr(Boolean soReuseAddr) {
        this.soReuseAddr = soReuseAddr;
    }

    public MessageSizeEstimator getMessageSizeEstimatorBuild() {
        return Objects.isNull(this.messageSizeEstimator) || this.messageSizeEstimator == 8 ? DefaultMessageSizeEstimator.DEFAULT : new DefaultMessageSizeEstimator(this.getMessageSizeEstimator().intValue());
    }

    public Integer getMessageSizeEstimator() {
        return this.messageSizeEstimator;
    }

    public void setMessageSizeEstimator(Integer messageSizeEstimator) {
        this.messageSizeEstimator = messageSizeEstimator;
    }

    public Boolean getSingleEventExecutorPerGroup() {
        return this.singleEventExecutorPerGroup;
    }

    public void setSingleEventExecutorPerGroup(Boolean singleEventExecutorPerGroup) {
        this.singleEventExecutorPerGroup = singleEventExecutorPerGroup;
    }
}

