/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ShenyuThreadFactory
implements ThreadFactory {
    private static final AtomicLong THREAD_NUMBER = new AtomicLong(1L);
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("shenyu");
    private final boolean daemon;
    private final String namePrefix;
    private final int priority;

    private ShenyuThreadFactory(String namePrefix, boolean daemon, int priority) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
        this.priority = priority;
    }

    public static ThreadFactory create(String namePrefix, boolean daemon) {
        return ShenyuThreadFactory.create(namePrefix, daemon, 5);
    }

    public static ThreadFactory create(String namePrefix, boolean daemon, int priority) {
        return new ShenyuThreadFactory(namePrefix, daemon, priority);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(THREAD_GROUP, runnable, THREAD_GROUP.getName() + "-" + this.namePrefix + "-" + THREAD_NUMBER.getAndIncrement());
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }
}

