/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.enums;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum FileDataSplitter implements Serializable
{
    CSV(","),
    TSV("\t"),
    GEOJSON(""),
    WKT("\t"),
    WKB("\t"),
    COMMA(","),
    TAB("\t"),
    QUESTIONMARK("?"),
    SINGLEQUOTE("'"),
    QUOTE("\""),
    UNDERSCORE("_"),
    DASH("-"),
    PERCENT("%"),
    TILDE("~"),
    PIPE("|"),
    SEMICOLON(";");

    private final String splitter;
    private static final Map<String, FileDataSplitter> lookup;

    private FileDataSplitter(String splitter) {
        this.splitter = splitter;
    }

    public static FileDataSplitter getFileDataSplitter(String str) {
        FileDataSplitter f = lookup.get(str);
        if (f == null) {
            throw new IllegalArgumentException("[" + FileDataSplitter.class + "] Unsupported FileDataSplitter:" + str);
        }
        return f;
    }

    public String getDelimiter() {
        return this.splitter;
    }

    static {
        lookup = new HashMap<String, FileDataSplitter>();
        for (FileDataSplitter f : FileDataSplitter.values()) {
            lookup.put(f.getDelimiter(), f);
            lookup.put(f.name().toLowerCase(), f);
            lookup.put(f.name().toUpperCase(), f);
        }
    }
}

