/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.time;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.field.ImpreciseDateTimeField;
import uk.ac.rdg.resc.edal.time.FixedYearVariableMonthChronology;

final class MonthOfFixedYearDateTimeField
extends ImpreciseDateTimeField {
    private final FixedYearVariableMonthChronology chron;
    private final int[] daysInMonth;
    private final int numMonthsInYear;

    public MonthOfFixedYearDateTimeField(FixedYearVariableMonthChronology chron) {
        super(DateTimeFieldType.monthOfYear(), chron.getAverageMillisInMonth());
        this.chron = chron;
        this.daysInMonth = chron.getMonthLengths();
        this.numMonthsInYear = chron.getMonthLengths().length;
    }

    @Override
    public int get(long instant) {
        int dayOfYear = this.chron.dayOfYear().get(instant);
        int totalDays = 0;
        for (int i = 0; i < this.daysInMonth.length; ++i) {
            if (dayOfYear > (totalDays += this.daysInMonth[i])) continue;
            return i + 1;
        }
        throw new AssertionError((Object)"Shouldn't get here");
    }

    @Override
    public long set(long instant, int value) {
        if (value < 1 || value > this.numMonthsInYear) {
            throw new IllegalFieldValueException(this.getType(), (Number)value, (Number)1, (Number)this.numMonthsInYear);
        }
        int monthOfYear = this.get(instant);
        int monthsToAdd = value - monthOfYear;
        return this.add(instant, monthsToAdd);
    }

    @Override
    public long add(long instant, int numMonths) {
        long newInstant;
        block5: {
            int numMonthsToAdd;
            int monthOfYear;
            block4: {
                if (numMonths == 0) {
                    return instant;
                }
                int numYearsToAdd = numMonths / this.numMonthsInYear;
                newInstant = instant + (long)numYearsToAdd * this.chron.years().getUnitMillis();
                monthOfYear = this.get(instant);
                numMonthsToAdd = numMonths % this.numMonthsInYear;
                if (numMonthsToAdd <= 0) break block4;
                for (int i = 0; i < numMonthsToAdd; ++i) {
                    int monthToAdd = monthOfYear - 1 + i;
                    long millisToAdd = (long)this.daysInMonth[monthToAdd %= this.numMonthsInYear] * this.chron.days().getUnitMillis();
                    newInstant += millisToAdd;
                }
                break block5;
            }
            if (numMonthsToAdd >= 0) break block5;
            for (int i = 0; i < Math.abs(numMonthsToAdd); ++i) {
                int monthToSubtract = monthOfYear - 2 - i;
                if (monthToSubtract < 0) {
                    monthToSubtract += this.numMonthsInYear;
                }
                long millisToSubtract = (long)this.daysInMonth[monthToSubtract] * this.chron.days().getUnitMillis();
                newInstant -= millisToSubtract;
            }
        }
        return newInstant;
    }

    @Override
    public long add(long instant, long numMonths) {
        if (numMonths > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value too large");
        }
        return this.add(instant, (int)numMonths);
    }

    @Override
    public long roundFloor(long instant) {
        int year = this.chron.year().get(instant);
        int monthOfYear = this.get(instant);
        int numCompleteMonths = monthOfYear - 1;
        long millis = (long)(year - 1970) * this.chron.years().getUnitMillis();
        for (int i = 0; i < numCompleteMonths; ++i) {
            millis += (long)this.daysInMonth[i] * this.chron.days().getUnitMillis();
        }
        return millis;
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return this.numMonthsInYear;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.chron.years();
    }

    @Override
    public boolean isLenient() {
        return false;
    }
}

