/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;

class BasicPreparedGeometry
implements PreparedGeometry {
    private final Geometry baseGeom;
    private final List representativePts;

    public BasicPreparedGeometry(Geometry geom) {
        this.baseGeom = geom;
        this.representativePts = ComponentCoordinateExtracter.getCoordinates(geom);
    }

    @Override
    public Geometry getGeometry() {
        return this.baseGeom;
    }

    public List getRepresentativePoints() {
        return this.representativePts;
    }

    public boolean isAnyTargetComponentInTest(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        for (Coordinate p : this.representativePts) {
            if (!locator.intersects(p, testGeom)) continue;
            return true;
        }
        return false;
    }

    protected boolean envelopesIntersect(Geometry g2) {
        return this.baseGeom.getEnvelopeInternal().intersects(g2.getEnvelopeInternal());
    }

    protected boolean envelopeCovers(Geometry g2) {
        return this.baseGeom.getEnvelopeInternal().covers(g2.getEnvelopeInternal());
    }

    @Override
    public boolean contains(Geometry g2) {
        return this.baseGeom.contains(g2);
    }

    @Override
    public boolean containsProperly(Geometry g2) {
        if (!this.baseGeom.getEnvelopeInternal().contains(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.baseGeom.relate(g2, "T**FF*FF*");
    }

    @Override
    public boolean coveredBy(Geometry g2) {
        return this.baseGeom.coveredBy(g2);
    }

    @Override
    public boolean covers(Geometry g2) {
        return this.baseGeom.covers(g2);
    }

    @Override
    public boolean crosses(Geometry g2) {
        return this.baseGeom.crosses(g2);
    }

    @Override
    public boolean disjoint(Geometry g2) {
        return !this.intersects(g2);
    }

    @Override
    public boolean intersects(Geometry g2) {
        return this.baseGeom.intersects(g2);
    }

    @Override
    public boolean overlaps(Geometry g2) {
        return this.baseGeom.overlaps(g2);
    }

    @Override
    public boolean touches(Geometry g2) {
        return this.baseGeom.touches(g2);
    }

    @Override
    public boolean within(Geometry g2) {
        return this.baseGeom.within(g2);
    }

    public String toString() {
        return this.baseGeom.toString();
    }
}

