/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.geojson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.wololo.geojson.Feature;
import org.wololo.geojson.FeatureCollection;
import org.wololo.geojson.GeoJSON;
import org.wololo.geojson.Geometry;

public class GeoJSONFactory {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static GeoJSON create(String json) {
        try {
            JsonNode node = mapper.readTree(json);
            String type = node.get("type").asText();
            if (type.equals("FeatureCollection")) {
                return GeoJSONFactory.readFeatureCollection(node);
            }
            if (type.equals("Feature")) {
                return GeoJSONFactory.readFeature(node);
            }
            return GeoJSONFactory.readGeometry(node, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static FeatureCollection readFeatureCollection(JsonNode node) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        Iterator<JsonNode> it = node.get("features").iterator();
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (it.hasNext()) {
            JsonNode jFeature = it.next();
            features.add(GeoJSONFactory.readFeature(jFeature));
        }
        return new FeatureCollection(features.toArray(new Feature[features.size()]));
    }

    private static Feature readFeature(JsonNode node) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        JsonNode geometryNode = node.get("geometry");
        MapType javaType = mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        JsonNode id = node.get("id");
        Map properties = (Map)mapper.readValue(node.get("properties").traverse(), (JavaType)javaType);
        Geometry geometry = GeoJSONFactory.readGeometry(geometryNode);
        return new Feature(id, geometry, properties);
    }

    private static Geometry readGeometry(JsonNode node) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        if (!node.isNull()) {
            String type = node.get("type").asText();
            return GeoJSONFactory.readGeometry(node, type);
        }
        return null;
    }

    private static Geometry readGeometry(JsonNode node, String type) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        return (Geometry)mapper.readValue(node.traverse(), Class.forName("org.wololo.geojson." + type));
    }
}

