/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.udtfs;

import java.util.stream.Stream;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.utils.ValidDetail;
import org.apache.sedona.snowflake.snowsql.GeometrySerde;
import org.apache.sedona.snowflake.snowsql.annotations.UDTFAnnotations;
import org.locationtech.jts.io.ParseException;

@UDTFAnnotations.TabularFunc(name="ST_IsValidDetail", argNames={"geom", "flag"})
public class ST_IsValidDetail {
    public static Class getOutputClass() {
        return OutputRow.class;
    }

    public Stream<OutputRow> process(byte[] geometry, Integer flag) throws ParseException {
        ValidDetail validDetail = Functions.isValidDetail(GeometrySerde.deserialize(geometry), flag);
        return Stream.of(new OutputRow(validDetail));
    }

    public static class OutputRow {
        public final boolean valid;
        public final String reason;
        public final byte[] location;

        public OutputRow(ValidDetail validDetail) {
            this.valid = validDetail.valid;
            this.reason = validDetail.reason;
            this.location = GeometrySerde.serialize(validDetail.location);
        }
    }
}

