/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.media.jai.RasterFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class RasterConstructorsForTesting {
    private RasterConstructorsForTesting() {
    }

    public static GridCoverage2D makeRasterForTesting(int numBand, String bandDataType, String sampleModelType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) {
        ColorModel colorModel;
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterConstructorsForTesting.createRasterWithSampleModel(sampleModelType, bandDataType, widthInPixel, heightInPixel, numBand);
        for (int k = 0; k < numBand; ++k) {
            for (int y = 0; y < heightInPixel; ++y) {
                for (int x = 0; x < widthInPixel; ++x) {
                    double value = k + y * widthInPixel + x;
                    raster.setSample(x, y, k, value);
                }
            }
        }
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        int rasterDataType = raster.getDataBuffer().getDataType();
        if (!sampleModelType.contains("Packed")) {
            BogusColorSpace cs = new BogusColorSpace(numBand);
            int[] nBits = new int[numBand];
            Arrays.fill(nBits, DataBuffer.getDataTypeSize(rasterDataType));
            colorModel = new ComponentColorModel((ColorSpace)cs, nBits, false, true, 1, rasterDataType);
        } else if (sampleModelType.equals("SinglePixelPackedSampleModel")) {
            colorModel = new DirectColorModel(32, 15, 240, 3840, 61440);
        } else if (sampleModelType.equals("MultiPixelPackedSampleModel")) {
            byte[] arr = new byte[16];
            for (int k = 0; k < 16; ++k) {
                arr[k] = (byte)(k * 16);
            }
            colorModel = new IndexColorModel(4, arr.length, arr, arr, arr);
        } else {
            throw new IllegalArgumentException("Unknown sample model type: " + sampleModelType);
        }
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        return gridCoverageFactory.create((CharSequence)"genericCoverage", (RenderedImage)image, gridGeometry, null, null, null);
    }

    private static WritableRaster createRasterWithSampleModel(String sampleModelType, String bandDataType, int widthInPixel, int heightInPixel, int numBand) {
        WritableRaster raster;
        int dataType = RasterUtils.getDataTypeCode(bandDataType);
        switch (sampleModelType) {
            case "BandedSampleModel": {
                raster = RasterFactory.createBandedRaster((int)dataType, (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
                break;
            }
            case "PixelInterleavedSampleModel": {
                int scanlineStride = widthInPixel * numBand;
                int[] bandOffsets = new int[numBand];
                for (int i = 0; i < numBand; ++i) {
                    bandOffsets[i] = i;
                }
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(dataType, widthInPixel, heightInPixel, numBand, scanlineStride, bandOffsets);
                raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
                break;
            }
            case "PixelInterleavedSampleModelComplex": {
                int pixelStride = numBand + 2;
                int scanlineStride = widthInPixel * pixelStride + 5;
                int[] bandOffsets = new int[numBand];
                for (int i = 0; i < numBand; ++i) {
                    bandOffsets[i] = i;
                }
                ArrayUtils.shuffle(bandOffsets);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(dataType, widthInPixel, heightInPixel, pixelStride, scanlineStride, bandOffsets);
                raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
                break;
            }
            case "ComponentSampleModel": {
                int pixelStride = numBand + 1;
                int scanlineStride = widthInPixel * pixelStride + 5;
                int[] bankIndices = new int[numBand];
                for (int i = 0; i < numBand; ++i) {
                    bankIndices[i] = i;
                }
                ArrayUtils.shuffle(bankIndices);
                int[] bandOffsets = new int[numBand];
                for (int i = 0; i < numBand; ++i) {
                    bandOffsets[i] = (int)(Math.random() * (double)widthInPixel);
                }
                ComponentSampleModel sm = new ComponentSampleModel(dataType, widthInPixel, heightInPixel, pixelStride, scanlineStride, bankIndices, bandOffsets);
                raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
                break;
            }
            case "SinglePixelPackedSampleModel": {
                if (dataType != 3) {
                    throw new IllegalArgumentException("only supports creating SinglePixelPackedSampleModel with int data type");
                }
                if (numBand != 4) {
                    throw new IllegalArgumentException("only supports creating SinglePixelPackedSampleModel with 4 bands");
                }
                int bitsPerBand = 4;
                int scanlineStride = widthInPixel + 5;
                int[] bitMasks = new int[numBand];
                int baseMask = (1 << bitsPerBand) - 1;
                for (int i = 0; i < numBand; ++i) {
                    bitMasks[i] = baseMask << i * bitsPerBand;
                }
                SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(dataType, widthInPixel, heightInPixel, scanlineStride, bitMasks);
                raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
                break;
            }
            case "MultiPixelPackedSampleModel": {
                if (dataType != 0) {
                    throw new IllegalArgumentException("only supports creating MultiPixelPackedSampleModel with byte data type");
                }
                if (numBand != 1) {
                    throw new IllegalArgumentException("only supports creating MultiPixelPackedSampleModel with 1 band");
                }
                int numberOfBits = 4;
                int scanlineStride = widthInPixel * numberOfBits / 8 + 2;
                MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(dataType, widthInPixel, heightInPixel, numberOfBits, scanlineStride, 80);
                raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown sample model type: " + sampleModelType);
            }
        }
        return raster;
    }
}

