/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public class GeometryLocateAlongProcessor {
    private final Map<Class<?>, BiFunction<Geometry, double[], Geometry>> geometryFunctions = new HashMap();

    public GeometryLocateAlongProcessor() {
        this.geometryFunctions.put(Point.class, (geometry, params) -> this.locateAlongPoint((Point)geometry, params[0], params[1]));
        this.geometryFunctions.put(MultiPoint.class, (geometry, params) -> this.locateAlongMultiPoint((MultiPoint)geometry, params[0], params[1]));
        this.geometryFunctions.put(LineString.class, (geometry, params) -> this.locateAlongLineString((LineString)geometry, params[0], params[1]));
        this.geometryFunctions.put(MultiLineString.class, (geometry, params) -> this.locateAlongMultiLineString((MultiLineString)geometry, params[0], params[1]));
    }

    public static Geometry processGeometry(Geometry geometry, double measure, double offset) {
        GeometryLocateAlongProcessor processor = new GeometryLocateAlongProcessor();
        BiFunction<Geometry, double[], Geometry> function = processor.geometryFunctions.get(geometry.getClass());
        if (function != null) {
            return function.apply(geometry, new double[]{measure, offset});
        }
        throw new IllegalArgumentException(String.format("%s geometry type not supported, supported types are: (Multi)Point and (Multi)LineString.", geometry.getGeometryType()));
    }

    private Geometry locateAlongPoint(Point point, double measure, double offset) {
        if (measure == point.getCoordinate().getM()) {
            return point;
        }
        return null;
    }

    private Geometry locateAlongMultiPoint(MultiPoint multiPoint, double measure, double offset) {
        Point[] points = new Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            points[i] = (Point)this.locateAlongPoint((Point)multiPoint.getGeometryN(i), measure, offset);
        }
        return multiPoint.getFactory().createMultiPoint((Point[])Arrays.stream(points).filter(Objects::nonNull).toArray(Point[]::new));
    }

    private Geometry locateAlongLineString(LineString lineString, double measure, double offset) {
        Coordinate[] coordinates = lineString.getCoordinates();
        CoordinateList coordinateList = new CoordinateList();
        for (int i = 1; i < coordinates.length; ++i) {
            double position;
            double measure2;
            Coordinate coordinate1 = coordinates[i - 1];
            Coordinate coordinate2 = coordinates[i];
            CoordinateXYZM newCoordinate = new CoordinateXYZM();
            double measure1 = coordinate1.getM();
            if (measure < Math.min(measure1, measure2 = coordinate2.getM()) || measure > Math.max(measure1, measure2)) continue;
            if (measure1 == measure2) {
                if (coordinate1.equals(coordinate2)) {
                    newCoordinate.setX(coordinate1.getX());
                    newCoordinate.setY(coordinate1.getY());
                    newCoordinate.setZ(coordinate1.getZ());
                    newCoordinate.setM(coordinate1.getM());
                    coordinateList.add(newCoordinate, false);
                    continue;
                }
                position = 0.5;
            } else {
                position = (measure - measure1) / (measure2 - measure1);
            }
            newCoordinate.setX(coordinate1.x + (coordinate2.x - coordinate1.x) * position);
            newCoordinate.setY(coordinate1.y + (coordinate2.y - coordinate1.y) * position);
            newCoordinate.setZ(coordinate1.z + (coordinate2.z - coordinate1.z) * position);
            newCoordinate.setM(measure);
            if (offset != 0.0) {
                double theta = Math.atan2(coordinate2.y - coordinate1.y, coordinate2.x - coordinate1.x);
                newCoordinate.setX(newCoordinate.x - Math.sin(theta) * offset);
                newCoordinate.setY(newCoordinate.y + Math.cos(theta) * offset);
            }
            coordinateList.add(newCoordinate, false);
        }
        return lineString.getFactory().createMultiPointFromCoords((Coordinate[])Arrays.stream(coordinateList.toCoordinateArray()).filter(Objects::nonNull).toArray(Coordinate[]::new));
    }

    private Geometry locateAlongMultiLineString(MultiLineString multiLineString, double measure, double offset) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            MultiPoint mPoint = (MultiPoint)this.locateAlongLineString((LineString)multiLineString.getGeometryN(i), measure, offset);
            for (int j = 0; j < mPoint.getNumGeometries(); ++j) {
                points.add((Point)mPoint.getGeometryN(j));
            }
        }
        return multiLineString.getFactory().createMultiPoint(points.toArray(new Point[0]));
    }
}

