/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.embedded;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authz.api.RangerAuthzApiErrorCode;
import org.apache.ranger.authz.api.RangerAuthzErrorCode;
import org.apache.ranger.authz.api.RangerAuthzException;
import org.apache.ranger.authz.embedded.RangerAuthzAuditHandler;
import org.apache.ranger.authz.model.RangerAccessContext;
import org.apache.ranger.authz.model.RangerAccessInfo;
import org.apache.ranger.authz.model.RangerAuthzRequest;
import org.apache.ranger.authz.model.RangerAuthzResult;
import org.apache.ranger.authz.model.RangerResourceInfo;
import org.apache.ranger.authz.model.RangerResourcePermissions;
import org.apache.ranger.authz.model.RangerUserInfo;
import org.apache.ranger.authz.util.RangerResourceNameParser;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthzPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthzPlugin.class);
    private final RangerBasePlugin plugin;
    private final Map<String, RangerResourceNameParser> rrnTemplates = new HashMap<String, RangerResourceNameParser>();

    public RangerAuthzPlugin(String serviceType, String serviceName, Properties properties) {
        this.plugin = new RangerBasePlugin(RangerAuthzPlugin.getPluginConfig(serviceType, serviceName, properties)){

            public void setPolicies(ServicePolicies policies) {
                super.setPolicies(policies);
                RangerAuthzPlugin.this.updateResourceTemplates();
            }
        };
        this.plugin.init();
    }

    public void cleanup() {
        this.plugin.cleanup();
    }

    public RangerAuthzResult authorize(RangerAuthzRequest request, RangerAuthzAuditHandler auditHandler) throws RangerAuthzException {
        RangerUserInfo userInfo = request.getUser();
        RangerAccessInfo access = request.getAccess();
        RangerAccessContext context = request.getContext();
        Set permissions = access.getPermissions();
        RangerAuthzResult ret = new RangerAuthzResult(request.getRequestId(), new HashMap(permissions.size()));
        RangerAccessResource resource = this.getResource(access.getResource().getName(), access.getResource().getAttributes());
        RangerAccessRequestImpl accessRequest = new RangerAccessRequestImpl(resource, null, userInfo.getName(), userInfo.getGroups(), userInfo.getRoles());
        this.initializeRequest(accessRequest, context);
        boolean hasDeny = false;
        boolean hasAllow = false;
        boolean hasNotDetermined = false;
        for (String permission : permissions) {
            RangerAuthzResult.AccessDecision permDecision;
            accessRequest.setAccessType(permission);
            accessRequest.setContext(new HashMap(context.getAdditionalInfo()));
            RangerAuthzResult.ResultInfo result = this.evaluate((RangerAccessRequest)accessRequest, auditHandler);
            RangerAuthzResult.PermissionResult permResult = new RangerAuthzResult.PermissionResult(permission, result);
            if (CollectionUtils.isNotEmpty((Collection)access.getResource().getSubResources())) {
                permResult.setAccess(new RangerAuthzResult.AccessResult());
                permResult.setSubResources(new HashMap(access.getResource().getSubResources().size()));
                for (String subResourceName : access.getResource().getSubResources()) {
                    accessRequest.setResource(this.getSubResource(resource, subResourceName));
                    accessRequest.setContext(new HashMap(context.getAdditionalInfo()));
                    RangerAuthzResult.ResultInfo subResourceResult = this.evaluate((RangerAccessRequest)accessRequest, auditHandler);
                    this.updateResult(subResourceResult.getAccess(), permResult.getAccess());
                    permResult.getSubResources().put(subResourceName, subResourceResult);
                }
            }
            if (permResult.getAccess().getDecision() == RangerAuthzResult.AccessDecision.DENY) {
                permResult.setDataMask(null);
                permResult.setRowFilter(null);
            }
            ret.getPermissions().put(permission, permResult);
            RangerAuthzResult.AccessDecision accessDecision = permDecision = permResult.getAccess() == null ? RangerAuthzResult.AccessDecision.NOT_DETERMINED : permResult.getAccess().getDecision();
            if (permDecision == RangerAuthzResult.AccessDecision.DENY) {
                hasDeny = true;
                continue;
            }
            if (permDecision == RangerAuthzResult.AccessDecision.ALLOW) {
                hasAllow = true;
                continue;
            }
            hasNotDetermined = true;
        }
        if (hasDeny) {
            ret.setDecision(RangerAuthzResult.AccessDecision.DENY);
        } else if (hasNotDetermined) {
            ret.setDecision(RangerAuthzResult.AccessDecision.NOT_DETERMINED);
        } else if (hasAllow) {
            ret.setDecision(RangerAuthzResult.AccessDecision.ALLOW);
        }
        return ret;
    }

    public RangerResourcePermissions getResourcePermissions(RangerResourceInfo resource, RangerAccessContext context) throws RangerAuthzException {
        RangerResourcePermissions ret = new RangerResourcePermissions();
        RangerAccessRequestImpl request = new RangerAccessRequestImpl();
        ret.setResource(resource);
        request.setResource(this.getResource(resource.getName(), null));
        this.initializeRequest(request, context);
        RangerResourceACLs acls = this.plugin.getResourceACLs((RangerAccessRequest)request);
        if (acls != null) {
            RangerResourceACLs.AccessResult acl;
            String permission;
            for (Map.Entry entry : acls.getUserACLs().entrySet()) {
                String userName = (String)entry.getKey();
                Map userAcls = (Map)entry.getValue();
                if (userAcls == null) continue;
                for (Map.Entry aclEntry : userAcls.entrySet()) {
                    permission = (String)aclEntry.getKey();
                    acl = (RangerResourceACLs.AccessResult)aclEntry.getValue();
                    ret.setUserPermission(userName, permission, new RangerAuthzResult.PermissionResult(permission, new RangerAuthzResult.ResultInfo(this.toAccessResult(acl), null, null, null)));
                }
            }
            for (Map.Entry entry : acls.getGroupACLs().entrySet()) {
                String groupName = (String)entry.getKey();
                Map groupAcls = (Map)entry.getValue();
                if (groupAcls == null) continue;
                for (Map.Entry aclEntry : groupAcls.entrySet()) {
                    permission = (String)aclEntry.getKey();
                    acl = (RangerResourceACLs.AccessResult)aclEntry.getValue();
                    ret.setGroupPermission(groupName, permission, new RangerAuthzResult.PermissionResult(permission, new RangerAuthzResult.ResultInfo(this.toAccessResult(acl), null, null, null)));
                }
            }
            for (Map.Entry entry : acls.getRoleACLs().entrySet()) {
                String roleName = (String)entry.getKey();
                Map roleAcls = (Map)entry.getValue();
                if (roleAcls == null) continue;
                for (Map.Entry aclEntry : roleAcls.entrySet()) {
                    permission = (String)aclEntry.getKey();
                    acl = (RangerResourceACLs.AccessResult)aclEntry.getValue();
                    ret.setRolePermission(roleName, permission, new RangerAuthzResult.PermissionResult(permission, new RangerAuthzResult.ResultInfo(this.toAccessResult(acl), null, null, null)));
                }
            }
        }
        return ret;
    }

    RangerBasePlugin getPlugin() {
        return this.plugin;
    }

    private RangerAccessResource getResource(String resource, Map<String, Object> attributes) throws RangerAuthzException {
        Map<String, Object> resourceMap = this.getResourceAsMap(resource);
        Object ownerName = attributes != null ? attributes.get("OWNER") : null;
        return new RangerAccessResourceImpl(resourceMap, ownerName != null ? ownerName.toString() : null);
    }

    private RangerAccessResource getSubResource(RangerAccessResource parent, String subResourceName) {
        HashMap<String, String> elements = new HashMap<String, String>(parent.getAsMap());
        if (StringUtils.isNotBlank((CharSequence)subResourceName)) {
            String[] parts = subResourceName.split(":", 2);
            elements.put(parts[0], parts.length > 1 ? parts[1] : "");
        }
        return new RangerAccessResourceImpl(elements, parent.getOwnerUser());
    }

    private void initializeRequest(RangerAccessRequestImpl request, RangerAccessContext context) {
        request.setAccessTime(new Date(context.getAccessTime()));
        request.setClientIPAddress(context.getClientIpAddress());
        request.setForwardedAddresses(context.getForwardedIpAddresses());
        request.setClientType(this.getClientType(context.getAdditionalInfo()));
        request.setClusterType(this.getClusterType(context.getAdditionalInfo()));
        request.setClusterName(this.getClusterName(context.getAdditionalInfo()));
        request.setRequestData(this.getRequestData(context.getAdditionalInfo()));
        request.setContext(new HashMap(context.getAdditionalInfo()));
    }

    private String getClientType(Map<String, Object> context) {
        Object ret = context != null ? context.get("clientType") : null;
        return ret != null ? ret.toString() : null;
    }

    private String getClusterType(Map<String, Object> context) {
        Object ret = context != null ? context.get("clusterType") : null;
        return ret != null ? ret.toString() : null;
    }

    private String getClusterName(Map<String, Object> context) {
        Object ret = context != null ? context.get("clusterName") : null;
        return ret != null ? ret.toString() : null;
    }

    private String getRequestData(Map<String, Object> context) {
        Object ret = context != null ? context.get("requestData") : null;
        return ret != null ? ret.toString() : null;
    }

    private void updateResult(RangerAuthzResult.AccessResult from, RangerAuthzResult.AccessResult to) {
        if (from == null || to == null || from.getDecision() == null || to.getDecision() == from.getDecision() || to.getDecision() == RangerAuthzResult.AccessDecision.DENY) {
            return;
        }
        if (to.getDecision() == null || from.getDecision() == RangerAuthzResult.AccessDecision.DENY || from.getDecision() == RangerAuthzResult.AccessDecision.NOT_DETERMINED) {
            to.setDecision(from.getDecision());
            to.setPolicy(from.getPolicy());
        }
    }

    private RangerAuthzResult.ResultInfo toPermissionResult(RangerAccessResult result) {
        RangerAuthzResult.ResultInfo ret = new RangerAuthzResult.ResultInfo(this.toAccessResult(result), null, null, null);
        if (result.getPolicyType() == 1) {
            ret.setDataMask(new RangerAuthzResult.DataMaskResult(result.getMaskType(), result.getMaskedValue(), ret.getAccess().getPolicy()));
        } else if (result.getPolicyType() == 2) {
            ret.setRowFilter(new RangerAuthzResult.RowFilterResult(result.getFilterExpr(), ret.getAccess().getPolicy()));
        }
        return ret;
    }

    private RangerAuthzResult.AccessResult toAccessResult(RangerResourceACLs.AccessResult result) {
        RangerAuthzResult.AccessResult ret = new RangerAuthzResult.AccessResult();
        if (result != null) {
            if (result.getIsFinal()) {
                if (result.getResult() == RangerPolicyEvaluator.ACCESS_ALLOWED.intValue()) {
                    ret.setDecision(RangerAuthzResult.AccessDecision.ALLOW);
                } else if (result.getResult() == RangerPolicyEvaluator.ACCESS_DENIED.intValue()) {
                    ret.setDecision(RangerAuthzResult.AccessDecision.DENY);
                } else if (result.getResult() == RangerPolicyEvaluator.ACCESS_CONDITIONAL.intValue()) {
                    ret.setDecision(RangerAuthzResult.AccessDecision.DENY);
                } else {
                    ret.setDecision(RangerAuthzResult.AccessDecision.NOT_DETERMINED);
                }
            } else {
                ret.setDecision(RangerAuthzResult.AccessDecision.NOT_DETERMINED);
            }
            if (result.getPolicy() != null) {
                ret.setPolicy(new RangerAuthzResult.PolicyInfo(result.getPolicy().getId(), result.getPolicy().getVersion()));
            } else {
                ret.setPolicy(null);
            }
        }
        return ret;
    }

    private RangerAuthzResult.AccessResult toAccessResult(RangerAccessResult result) {
        RangerAuthzResult.AccessResult ret = new RangerAuthzResult.AccessResult();
        if (result.getIsAccessDetermined()) {
            ret.setDecision(result.getIsAllowed() ? RangerAuthzResult.AccessDecision.ALLOW : RangerAuthzResult.AccessDecision.DENY);
        } else {
            ret.setDecision(RangerAuthzResult.AccessDecision.NOT_DETERMINED);
        }
        ret.setPolicy(this.toPolicyInfo(result));
        return ret;
    }

    private RangerAuthzResult.PolicyInfo toPolicyInfo(RangerAccessResult result) {
        return new RangerAuthzResult.PolicyInfo(Long.valueOf(result.getPolicyId()), result.getPolicyVersion());
    }

    private RangerAuthzResult.ResultInfo evaluate(RangerAccessRequest request, RangerAuthzAuditHandler auditHandler) {
        RangerAccessResult dataMaskResult;
        RangerAccessResult rowFilterResult;
        RangerAccessResult result = this.plugin.isAccessAllowed(request, (RangerAccessResultProcessor)auditHandler);
        RangerAuthzResult.ResultInfo ret = this.toPermissionResult(result);
        if (this.plugin.getServiceDefHelper().isRowFilterSupported(request.getResource().getKeys()) && (rowFilterResult = this.plugin.evalRowFilterPolicies(request, (RangerAccessResultProcessor)auditHandler)) != null && rowFilterResult.getIsAccessDetermined() && StringUtils.isNotBlank((CharSequence)rowFilterResult.getFilterExpr())) {
            ret.setRowFilter(new RangerAuthzResult.RowFilterResult(rowFilterResult.getFilterExpr(), this.toPolicyInfo(rowFilterResult)));
        }
        if (this.plugin.getServiceDefHelper().isDataMaskSupported(request.getResource().getKeys()) && (dataMaskResult = this.plugin.evalDataMaskPolicies(request, (RangerAccessResultProcessor)auditHandler)) != null && dataMaskResult.getIsAccessDetermined() && StringUtils.isNotBlank((CharSequence)dataMaskResult.getMaskType())) {
            ret.setDataMask(new RangerAuthzResult.DataMaskResult(dataMaskResult.getMaskType(), dataMaskResult.getMaskedValue(), this.toPolicyInfo(dataMaskResult)));
        }
        return ret;
    }

    private Map<String, Object> getResourceAsMap(String resource) throws RangerAuthzException {
        String[] resourceParts = resource.split(":", 2);
        String resourceType = resourceParts.length > 0 ? resourceParts[0] : null;
        String resourceValue = resourceParts.length > 1 ? resourceParts[1] : null;
        RangerResourceNameParser template = this.rrnTemplates.get(resourceType);
        if (template == null) {
            throw new RangerAuthzException((RangerAuthzErrorCode)RangerAuthzApiErrorCode.INVALID_REQUEST_RESOURCE_TYPE_NOT_FOUND, new Object[]{resourceType});
        }
        Map ret = template.parseToMap(resourceValue);
        if (ret == null) {
            throw new RangerAuthzException((RangerAuthzErrorCode)RangerAuthzApiErrorCode.INVALID_REQUEST_RESOURCE_VALUE_FOR_TYPE, new Object[]{resourceValue, resourceType});
        }
        return ret;
    }

    private void updateResourceTemplates() {
        RangerServiceDefHelper serviceDefHelper = this.plugin.getServiceDefHelper();
        if (serviceDefHelper != null) {
            for (String resourceType : serviceDefHelper.getAllResourceNames()) {
                String rrnTemplate = serviceDefHelper.getRrnTemplate(resourceType);
                RangerResourceNameParser existing = this.rrnTemplates.get(resourceType);
                if (existing != null && Objects.equals(existing.getTemplate(), rrnTemplate)) continue;
                LOG.info("updateResourceTemplates(): resourceType={} updated to rrnTemplate={}", (Object)resourceType, (Object)rrnTemplate);
                try {
                    this.rrnTemplates.put(resourceType, new RangerResourceNameParser(rrnTemplate));
                }
                catch (RangerAuthzException excp) {
                    LOG.warn("updateResourceTemplates(): failed to create resource template for resourceType={}, rrnTemplate={}", new Object[]{resourceType, rrnTemplate, excp});
                }
            }
        }
    }

    private static RangerPluginConfig getPluginConfig(String serviceType, String serviceName, Properties properties) {
        return new RangerPluginConfig(serviceType, serviceName, null, properties);
    }
}

