/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.embedded;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class RangerAuthzConfig {
    public static final String PROP_PREFIX_INIT_SERVICES = "ranger.authz.init.services";
    public static final String PROP_PREFIX_DEFAULT = "ranger.authz.default.";
    public static final String PROP_PREFIX_AUDIT = "ranger.authz.audit.";
    public static final String PROP_PREFIX_SERVICE = "ranger.authz.service.";
    public static final String PROP_PREFIX_SERVICE_TYPE = "ranger.authz.servicetype.";
    private final Properties properties;

    public RangerAuthzConfig(Properties properties) {
        this.properties = properties;
    }

    public String[] getInitServices() {
        String initServices = this.properties.getProperty(PROP_PREFIX_INIT_SERVICES);
        if (StringUtils.isBlank((CharSequence)initServices)) {
            return new String[0];
        }
        return initServices.split(",");
    }

    public Properties getAuditProperties() {
        Properties ret = new Properties();
        for (String propName : this.properties.stringPropertyNames()) {
            if (!propName.startsWith(PROP_PREFIX_AUDIT)) continue;
            String propValue = this.properties.getProperty(propName);
            String propSuffix = propName.substring(PROP_PREFIX_AUDIT.length());
            String pluginPropName = "xasecure.audit." + propSuffix;
            ret.setProperty(pluginPropName, propValue);
        }
        return ret;
    }

    public Properties getServiceProperties(String serviceName, String serviceType) {
        String pluginPropName;
        String propSuffix;
        String propValue;
        Properties ret = new Properties();
        if (StringUtils.isBlank((CharSequence)serviceType)) {
            serviceType = this.getServiceTypeForService(serviceName);
        }
        String pluginPropPrefix = "ranger.plugin." + serviceType + ".";
        for (String propName : this.properties.stringPropertyNames()) {
            if (!propName.startsWith(PROP_PREFIX_DEFAULT)) continue;
            String propValue2 = this.properties.getProperty(propName);
            String propSuffix2 = propName.substring(PROP_PREFIX_DEFAULT.length());
            String pluginPropName2 = pluginPropPrefix + propSuffix2;
            ret.setProperty(pluginPropName2, propValue2);
        }
        if (StringUtils.isNotBlank((CharSequence)serviceType)) {
            String svcTypePropPrefix = PROP_PREFIX_SERVICE_TYPE + serviceType + ".";
            for (String propName : this.properties.stringPropertyNames()) {
                if (!propName.startsWith(svcTypePropPrefix)) continue;
                propValue = this.properties.getProperty(propName);
                propSuffix = propName.substring(svcTypePropPrefix.length());
                pluginPropName = pluginPropPrefix + propSuffix;
                ret.setProperty(pluginPropName, propValue);
            }
        }
        String svcPropPrefix = PROP_PREFIX_SERVICE + serviceName + ".";
        for (String propName : this.properties.stringPropertyNames()) {
            if (!propName.startsWith(svcPropPrefix)) continue;
            propValue = this.properties.getProperty(propName);
            propSuffix = propName.substring(svcPropPrefix.length());
            pluginPropName = pluginPropPrefix + propSuffix;
            ret.setProperty(pluginPropName, propValue);
        }
        return ret;
    }

    public String getServiceTypeForService(String serviceName) {
        return this.properties.getProperty(PROP_PREFIX_SERVICE + serviceName + ".servicetype");
    }

    public String getDefaultServiceNameForServiceType(String serviceType) {
        return this.properties.getProperty(PROP_PREFIX_SERVICE_TYPE + serviceType + ".default.service");
    }
}

