/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.model.AbstractTagSource;
import org.apache.ranger.tagsync.model.TagSink;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.apache.ranger.tagsync.process.TagSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTagSource
extends AbstractTagSource
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FileTagSource.class);
    private String serviceTagsFileName;
    private URL serviceTagsFileURL;
    private long lastModifiedTimeInMillis = -1L;
    private long fileModTimeCheckIntervalInMs;
    private Thread myThread = null;

    public static void main(String[] args) {
        FileTagSource fileTagSource = new FileTagSource();
        TagSyncConfig config = TagSyncConfig.getInstance();
        Properties props = config.getProperties();
        if (args.length > 0) {
            String tagSourceFileName = args[0];
            LOG.info("TagSourceFileName is set to " + args[0]);
            props.setProperty("ranger.tagsync.source.file.filename", tagSourceFileName);
        }
        TagSynchronizer.printConfigurationProperties(props);
        boolean ret = TagSynchronizer.initializeKerberosIdentity(props);
        if (ret) {
            TagSink tagSink = TagSynchronizer.initializeTagSink(props);
            if (tagSink != null) {
                if (fileTagSource.initialize(props)) {
                    try {
                        tagSink.start();
                        fileTagSource.setTagSink(tagSink);
                        fileTagSource.synchUp();
                    }
                    catch (Exception exception) {
                        LOG.error("ServiceTags upload failed : ", (Throwable)exception);
                        System.exit(1);
                    }
                } else {
                    LOG.error("FileTagSource initialized failed, exiting.");
                    System.exit(1);
                }
            } else {
                LOG.error("TagSink initialialization failed, exiting.");
                System.exit(1);
            }
        } else {
            LOG.error("Error initializing kerberos identity");
            System.exit(1);
        }
    }

    @Override
    public boolean initialize(Properties props) {
        Properties properties;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FileTagSource.initialize()");
        }
        if (props == null || MapUtils.isEmpty((Map)props)) {
            LOG.error("No properties specified for FileTagSource initialization");
            properties = new Properties();
        } else {
            properties = props;
        }
        boolean ret = true;
        this.serviceTagsFileName = TagSyncConfig.getTagSourceFileName(properties);
        if (StringUtils.isBlank((String)this.serviceTagsFileName)) {
            ret = false;
            LOG.error("value of property 'ranger.tagsync.source.impl.class' is file and no value specified for property 'ranger.tagsync.filesource.filename'!");
        }
        if (ret) {
            this.fileModTimeCheckIntervalInMs = TagSyncConfig.getTagSourceFileModTimeCheckIntervalInMillis(properties);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Provided serviceTagsFileName=" + this.serviceTagsFileName);
                LOG.debug("'ranger.tagsync.filesource.modtime.check.interval':" + this.fileModTimeCheckIntervalInMs + "ms");
            }
            InputStream serviceTagsFileStream = null;
            File f = new File(this.serviceTagsFileName);
            if (f.exists() && f.isFile() && f.canRead()) {
                try {
                    serviceTagsFileStream = new FileInputStream(f);
                    this.serviceTagsFileURL = f.toURI().toURL();
                }
                catch (FileNotFoundException exception) {
                    LOG.error("Error processing input file:" + this.serviceTagsFileName + " or no privilege for reading file " + this.serviceTagsFileName, (Throwable)exception);
                }
                catch (MalformedURLException malformedException) {
                    LOG.error("Error processing input file:" + this.serviceTagsFileName + " cannot be converted to URL " + this.serviceTagsFileName, (Throwable)malformedException);
                }
            } else {
                URL fileURL = this.getClass().getResource(this.serviceTagsFileName);
                if (fileURL == null && !this.serviceTagsFileName.startsWith("/")) {
                    fileURL = this.getClass().getResource("/" + this.serviceTagsFileName);
                }
                if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(this.serviceTagsFileName)) == null && !this.serviceTagsFileName.startsWith("/")) {
                    fileURL = ClassLoader.getSystemClassLoader().getResource("/" + this.serviceTagsFileName);
                }
                if (fileURL != null) {
                    try {
                        serviceTagsFileStream = fileURL.openStream();
                        this.serviceTagsFileURL = fileURL;
                    }
                    catch (Exception exception) {
                        LOG.error(this.serviceTagsFileName + " is not a file", (Throwable)exception);
                    }
                } else {
                    LOG.warn("Error processing input file: URL not found for " + this.serviceTagsFileName + " or no privilege for reading file " + this.serviceTagsFileName);
                }
            }
            if (serviceTagsFileStream != null) {
                try {
                    serviceTagsFileStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== FileTagSource.initialize(): sourceFileName=" + this.serviceTagsFileName + ", result=" + ret);
        }
        return ret;
    }

    @Override
    public boolean start() {
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        return true;
    }

    @Override
    public void stop() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.myThread.interrupt();
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FileTagSource.run()");
        }
        while (true) {
            try {
                if (!TagSyncConfig.isTagSyncServiceActive()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("==> FileTagSource is running as server is active");
                }
                this.synchUp();
                continue;
            }
            catch (Exception e) {
                LOG.error("Caught exception..", (Throwable)e);
                continue;
            }
            finally {
                LOG.debug("Sleeping for [" + this.fileModTimeCheckIntervalInMs + "] milliSeconds");
                try {
                    Thread.sleep(this.fileModTimeCheckIntervalInMs);
                }
                catch (InterruptedException exception) {
                    LOG.error("Interrupted..: ", (Throwable)exception);
                    break;
                }
                continue;
            }
            break;
        }
    }

    private boolean isChanged() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FileTagSource.isChanged()");
        }
        boolean ret = false;
        long modificationTime = this.getModificationTime();
        if (modificationTime > this.lastModifiedTimeInMillis) {
            if (LOG.isDebugEnabled()) {
                Date modifiedDate = new Date(modificationTime);
                Date lastModifiedDate = new Date(this.lastModifiedTimeInMillis);
                LOG.debug("File modified at " + modifiedDate + "last-modified at " + lastModifiedDate);
            }
            ret = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== FileTagSource.isChanged(): result=" + ret);
        }
        return ret;
    }

    public void synchUp() throws Exception {
        if (this.isChanged()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Begin: update tags from source==>sink");
            }
            ServiceTags serviceTags = this.readFromFile();
            this.updateSink(serviceTags);
            this.lastModifiedTimeInMillis = this.getModificationTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("End: update tags from source==>sink");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("FileTagSource: no change found for synchronization.");
        }
    }

    private ServiceTags readFromFile() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FileTagSource.readFromFile(): sourceFileName=" + this.serviceTagsFileName);
        }
        ServiceTags ret = null;
        if (this.serviceTagsFileURL != null) {
            try (InputStream inputStream = this.serviceTagsFileURL.openStream();
                 InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));){
                ret = (ServiceTags)JsonUtils.jsonToObject((Reader)reader, ServiceTags.class);
            }
            catch (IOException e) {
                LOG.warn("Error processing input file: or no privilege for reading file " + this.serviceTagsFileName, (Throwable)e);
            }
        } else {
            LOG.error("Error reading file: " + this.serviceTagsFileName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== FileTagSource.readFromFile(): sourceFileName=" + this.serviceTagsFileName);
        }
        return ret;
    }

    private long getModificationTime() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FileTagSource.getLastModificationTime(): sourceFileName=" + this.serviceTagsFileName);
        }
        long ret = 0L;
        File sourceFile = new File(this.serviceTagsFileName);
        if (sourceFile.exists() && sourceFile.isFile() && sourceFile.canRead()) {
            ret = sourceFile.lastModified();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== FileTagSource.lastModificationTime(): serviceTagsFileName=" + this.serviceTagsFileName + " result=" + new Date(ret));
        }
        return ret;
    }
}

