/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.solr.client;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.services.solr.client.ServiceSolrClient;

public class ServiceSolrConnectionMgr {
    private static final String SOLR_ZOOKEEPER_QUORUM = "solr.zookeeper.quorum";
    private static final String SOLR_URL = "solr.url";

    public static ServiceSolrClient getSolrClient(String serviceName, Map<String, String> configs) throws Exception {
        String solr_url = configs.get(SOLR_URL);
        String zk_url = configs.get(SOLR_ZOOKEEPER_QUORUM);
        if (solr_url != null || zk_url != null) {
            boolean isSolrCloud = StringUtils.isNotEmpty((String)zk_url);
            String url = isSolrCloud ? zk_url : solr_url;
            ServiceSolrClient serviceSolrClient = new ServiceSolrClient(serviceName, configs, url, isSolrCloud);
            return serviceSolrClient;
        }
        throw new Exception("Required properties are not set for " + serviceName + ". URL or Zookeeper information not provided.");
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        ServiceSolrClient serviceSolrClient = ServiceSolrConnectionMgr.getSolrClient(serviceName, configs);
        return serviceSolrClient.connectionTest();
    }
}

