/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapconfigcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang.NullArgumentException;

public class LdapConfig {
    public static final String CONFIG_FILE = "input.properties";
    private static final String LGSYNC_LDAP_URL = "ranger.usersync.ldap.url";
    private static final String LGSYNC_LDAP_BIND_DN = "ranger.usersync.ldap.binddn";
    private static final String LGSYNC_LDAP_BIND_PASSWORD = "ranger.usersync.ldap.ldapbindpassword";
    private static final String LGSYNC_LDAP_AUTHENTICATION_MECHANISM = "ranger.usersync.ldap.authentication.mechanism";
    private static final String DEFAULT_AUTHENTICATION_MECHANISM = "simple";
    private static final String LGSYNC_SEARCH_BASE = "ranger.usersync.ldap.searchBase";
    private static final String LGSYNC_USER_SEARCH_BASE = "ranger.usersync.ldap.user.searchbase";
    private static final String LGSYNC_USER_SEARCH_SCOPE = "ranger.usersync.ldap.user.searchscope";
    private static final String LGSYNC_USER_OBJECT_CLASS = "ranger.usersync.ldap.user.objectclass";
    private static final String LGSYNC_USER_SEARCH_FILTER = "ranger.usersync.ldap.user.searchfilter";
    private static final String LGSYNC_USER_NAME_ATTRIBUTE = "ranger.usersync.ldap.user.nameattribute";
    private static final String LGSYNC_USER_GROUP_NAME_ATTRIBUTE = "ranger.usersync.ldap.user.groupnameattribute";
    public static final String UGSYNC_NONE_CASE_CONVERSION_VALUE = "none";
    public static final String UGSYNC_LOWER_CASE_CONVERSION_VALUE = "lower";
    private static final String UGSYNC_USERNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.username.caseconversion";
    private static final String DEFAULT_UGSYNC_USERNAME_CASE_CONVERSION_VALUE = "none";
    private static final String UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.groupname.caseconversion";
    private static final String DEFAULT_UGSYNC_GROUPNAME_CASE_CONVERSION_VALUE = "none";
    private static final String LGSYNC_PAGED_RESULTS_ENABLED = "ranger.usersync.pagedresultsenabled";
    private static final boolean DEFAULT_LGSYNC_PAGED_RESULTS_ENABLED = true;
    private static final String LGSYNC_PAGED_RESULTS_SIZE = "ranger.usersync.pagedresultssize";
    private static final int DEFAULT_LGSYNC_PAGED_RESULTS_SIZE = 500;
    private static final String LGSYNC_GROUP_SEARCH_ENABLED = "ranger.usersync.group.searchenabled";
    private static final boolean DEFAULT_LGSYNC_GROUP_SEARCH_ENABLED = false;
    private static final String LGSYNC_GROUP_SEARCH_BASE = "ranger.usersync.group.searchbase";
    private static final String LGSYNC_GROUP_SEARCH_SCOPE = "ranger.usersync.group.searchscope";
    private static final String LGSYNC_GROUP_OBJECT_CLASS = "ranger.usersync.group.objectclass";
    private static final String LGSYNC_GROUP_SEARCH_FILTER = "ranger.usersync.group.searchfilter";
    private static final String LGSYNC_GROUP_NAME_ATTRIBUTE = "ranger.usersync.group.nameattribute";
    private static final String LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME = "ranger.usersync.group.memberattributename";
    private static final String AUTHENTICATION_METHOD = "ranger.authentication.method";
    private static final String AD_DOMAIN = "ranger.ldap.ad.domain";
    private static final String USER_DN_PATTERN = "ranger.ldap.user.dnpattern";
    private static final String GROUP_ROLE_ATTRIBUTE = "ranger.ldap.group.roleattribute";
    private static final String GROUP_SEARCH_BASE = "ranger.ldap.group.searchbase";
    private static final String GROUP_SEARCH_FILTER = "ranger.ldap.group.searchfilter";
    private static final String AUTH_USERNAME = "ranger.admin.auth.sampleuser";
    private static final String AUTH_PASSWORD = "ranger.admin.auth.samplepassword";
    private Properties prop = new Properties();

    public LdapConfig(String configFile, String bindPasswd) {
        this.init(configFile, bindPasswd);
    }

    private void init(String configFile, String bindPasswd) {
        this.readConfigFile(configFile);
        this.prop.setProperty(LGSYNC_LDAP_BIND_PASSWORD, bindPasswd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String fileName) {
        block9: {
            try {
                InputStream in = this.getFileInputStream(fileName);
                if (in == null) break block9;
                try {
                    System.out.println("Reading ldap properties from " + fileName);
                    this.prop.load(in);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe);
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load configuration file [" + fileName + "]", e);
            }
        }
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = this.getClass().getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = this.getClass().getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }

    public String getLdapUrl() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_LDAP_URL);
        if (val == null || val.trim().isEmpty()) {
            throw new NullArgumentException(LGSYNC_LDAP_URL);
        }
        return val;
    }

    public String getLdapBindDn() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_LDAP_BIND_DN);
        if (val == null || val.trim().isEmpty()) {
            throw new NullArgumentException(LGSYNC_LDAP_BIND_DN);
        }
        return val;
    }

    public String getLdapBindPassword() {
        if (this.prop == null) {
            return null;
        }
        return this.prop.getProperty(LGSYNC_LDAP_BIND_PASSWORD);
    }

    public String getLdapAuthenticationMechanism() {
        String val = this.prop.getProperty(LGSYNC_LDAP_AUTHENTICATION_MECHANISM);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_AUTHENTICATION_MECHANISM;
        }
        return val;
    }

    public String getUserSearchBase() {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_BASE);
        if (val == null || val.trim().isEmpty()) {
            val = this.getSearchBase();
        }
        return val;
    }

    public int getUserSearchScope() {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_SCOPE);
        if (val == null || val.trim().isEmpty()) {
            return 2;
        }
        if ((val = val.trim().toLowerCase()).equals("0") || val.startsWith("base")) {
            return 0;
        }
        if (val.equals("1") || val.startsWith("one")) {
            return 1;
        }
        return 2;
    }

    public String getUserObjectClass() {
        String val = this.prop.getProperty(LGSYNC_USER_OBJECT_CLASS);
        return val;
    }

    public String getUserSearchFilter() {
        return this.prop.getProperty(LGSYNC_USER_SEARCH_FILTER);
    }

    public String getUserNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_NAME_ATTRIBUTE);
        return val;
    }

    public String getUserGroupNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_GROUP_NAME_ATTRIBUTE);
        return val;
    }

    public String getUserNameCaseConversion() {
        String ret = this.prop.getProperty(UGSYNC_USERNAME_CASE_CONVERSION_PARAM, "none");
        return ret.trim().toLowerCase();
    }

    public String getGroupNameCaseConversion() {
        String ret = this.prop.getProperty(UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM, "none");
        return ret.trim().toLowerCase();
    }

    public String getSearchBase() {
        return this.prop.getProperty(LGSYNC_SEARCH_BASE);
    }

    public boolean isPagedResultsEnabled() {
        String val = this.prop.getProperty(LGSYNC_PAGED_RESULTS_ENABLED);
        boolean pagedResultsEnabled = val == null || val.trim().isEmpty() ? true : Boolean.valueOf(val);
        return pagedResultsEnabled;
    }

    public int getPagedResultsSize() {
        String val = this.prop.getProperty(LGSYNC_PAGED_RESULTS_SIZE);
        int pagedResultsSize = val == null || val.trim().isEmpty() ? 500 : Integer.parseInt(val);
        if (pagedResultsSize < 1) {
            pagedResultsSize = 500;
        }
        return pagedResultsSize;
    }

    public boolean isGroupSearchEnabled() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_ENABLED);
        boolean groupSearchEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return groupSearchEnabled;
    }

    public String getGroupSearchBase() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_BASE);
        return val;
    }

    public int getGroupSearchScope() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_SCOPE);
        if (val == null || val.trim().isEmpty()) {
            return 2;
        }
        if ((val = val.trim().toLowerCase()).equals("0") || val.startsWith("base")) {
            return 0;
        }
        if (val.equals("1") || val.startsWith("one")) {
            return 1;
        }
        return 2;
    }

    public String getGroupObjectClass() {
        String val = this.prop.getProperty(LGSYNC_GROUP_OBJECT_CLASS);
        return val;
    }

    public String getGroupSearchFilter() {
        return this.prop.getProperty(LGSYNC_GROUP_SEARCH_FILTER);
    }

    public String getUserGroupMemberAttributeName() {
        String val = this.prop.getProperty(LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME);
        return val;
    }

    public String getGroupNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_GROUP_NAME_ATTRIBUTE);
        return val;
    }

    public String getAuthenticationMethod() {
        String val = this.prop.getProperty(AUTHENTICATION_METHOD);
        return val;
    }

    public String getAdDomain() {
        String val = this.prop.getProperty(AD_DOMAIN);
        return val;
    }

    public String getUserDnPattern() {
        String val = this.prop.getProperty(USER_DN_PATTERN);
        return val;
    }

    public String getGroupRoleAttribute() {
        String val = this.prop.getProperty(GROUP_ROLE_ATTRIBUTE);
        return val;
    }

    public String getAuthGroupSearchBase() {
        String val = this.prop.getProperty(GROUP_SEARCH_BASE);
        return val;
    }

    public String getAuthGroupSearchFilter() {
        String val = this.prop.getProperty(GROUP_SEARCH_FILTER);
        return val;
    }

    public String getAuthUsername() {
        return this.prop.getProperty(AUTH_USERNAME);
    }

    public String getAuthPassword() {
        return this.prop.getProperty(AUTH_PASSWORD);
    }

    public void updateInputPropFile(String ldapUrl, String bindDn, String bindPassword, String userSearchBase, String userSearchFilter, String authUser, String authPass) {
        try {
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.fileBased().setFileName(CONFIG_FILE)});
            FileBasedConfiguration config = (FileBasedConfiguration)builder.getConfiguration();
            this.prop.setProperty(LGSYNC_LDAP_URL, ldapUrl);
            this.prop.setProperty(LGSYNC_LDAP_BIND_DN, bindDn);
            this.prop.setProperty(LGSYNC_LDAP_BIND_PASSWORD, bindPassword);
            this.prop.setProperty(LGSYNC_USER_SEARCH_BASE, userSearchBase);
            this.prop.setProperty(LGSYNC_USER_SEARCH_FILTER, userSearchFilter);
            this.prop.setProperty(AUTH_USERNAME, authUser);
            this.prop.setProperty(AUTH_PASSWORD, authPass);
            config.setProperty(LGSYNC_LDAP_URL, (Object)ldapUrl);
            config.setProperty(LGSYNC_LDAP_BIND_DN, (Object)bindDn);
            config.setProperty(LGSYNC_USER_SEARCH_BASE, (Object)userSearchBase);
            config.setProperty(LGSYNC_USER_SEARCH_FILTER, (Object)userSearchFilter);
            config.setProperty(AUTH_USERNAME, (Object)authUser);
            builder.save();
        }
        catch (ConfigurationException e) {
            System.out.println("Failed to update input.properties: " + (Object)((Object)e));
        }
    }
}

