/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;

public class CurrentOutputUri
extends ContextAccessorFunction
implements Callable {
    @Override
    public int getSpecialProperties(Expression[] arguments) {
        return super.getSpecialProperties(arguments) | 0x2000000;
    }

    @Override
    public FunctionItem bindContext(XPathContext context) {
        String uri = context.getCurrentOutputUri();
        ConstantFunction fn = new ConstantFunction(uri == null ? EmptySequence.getInstance() : new AnyURIValue(uri));
        fn.setDetails(this.getDetails());
        fn.setRetainedStaticContext(this.getRetainedStaticContext());
        return fn;
    }

    public AnyURIValue evaluateItem(XPathContext context) throws XPathException {
        String uri = context.getCurrentOutputUri();
        return uri == null ? null : new AnyURIValue(uri);
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.itemOrEmpty(this.evaluateItem(context));
    }
}

